/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.armor.BarakoaMaskModel;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoayaToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.item.BarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemBarakoMask;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.MowzieArmorItem;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBarakoaMask
extends MowzieArmorItem
implements BarakoaMask {
    private final MaskType type;
    private static final BarakoaMaskMaterial BARAKOA_MASK_MATERIAL = new BarakoaMaskMaterial();

    public ItemBarakoaMask(MaskType type, Item.Properties properties) {
        super(BARAKOA_MASK_MATERIAL, EquipmentSlotType.HEAD, properties);
        this.type = type;
    }

    public Effect getPotion() {
        return this.type.potion;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack materialItemStack) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack headStack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (headStack.func_77973_b() instanceof ItemBarakoMask) {
            boolean didSpawn;
            if (((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SOL_VISAGE.breakable.get()).booleanValue() && !player.func_184812_l_()) {
                headStack.func_222118_a(2, (LivingEntity)player, p -> p.func_213334_d(hand));
            }
            if (didSpawn = this.spawnBarakoa(this.type, stack, player, (float)stack.func_77952_i() / (float)stack.func_77958_k())) {
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    private boolean spawnBarakoa(MaskType mask, ItemStack stack, PlayerEntity player, float durability) {
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
        if (playerCapability != null && playerCapability.getPackSize() < 10) {
            player.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKO_BELLY.get(), 1.5f, 1.0f);
            player.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKOA_BLOWDART.get(), 1.5f, 0.5f);
            double angle = player.func_70079_am();
            if (angle < 0.0) {
                angle += 360.0;
            }
            EntityBarakoanToPlayer barakoa = mask == MaskType.FAITH ? new EntityBarakoayaToPlayer((EntityType<? extends EntityBarakoayaToPlayer>)((EntityType)EntityHandler.BARAKOAYA_TO_PLAYER.get()), player.field_70170_p, player) : new EntityBarakoanToPlayer((EntityType<? extends EntityBarakoanToPlayer>)((EntityType)EntityHandler.BARAKOAN_TO_PLAYER.get()), player.field_70170_p, player);
            if (!player.field_70170_p.field_72995_K) {
                if (mask != MaskType.FAITH) {
                    int weapon = mask != MaskType.FURY ? barakoa.randomizeWeapon() : 0;
                    barakoa.setWeapon(weapon);
                }
                barakoa.func_70080_a(player.func_226277_ct_() + 1.0 * Math.sin(-angle * (Math.PI / 180)), player.func_226278_cu_() + 1.5, player.func_226281_cx_() + 1.0 * Math.cos(-angle * (Math.PI / 180)), (float)angle, 0.0f);
                barakoa.setActive(false);
                barakoa.active = false;
                player.field_70170_p.func_217376_c((Entity)barakoa);
                double vx = 0.5 * Math.sin(-angle * Math.PI / 180.0);
                double vy = 0.5;
                double vz = 0.5 * Math.cos(-angle * Math.PI / 180.0);
                barakoa.func_213293_j(vx, vy, vz);
                barakoa.func_70606_j((1.0f - durability) * barakoa.func_110138_aP());
                barakoa.setMask(mask);
                barakoa.setStoredMask(stack.func_77946_l());
                if (stack.func_82837_s()) {
                    barakoa.func_200203_b(stack.func_200301_q());
                }
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        BarakoaMaskModel<LivingEntity> model = MowziesMobs.PROXY.getBarakoaMaskModel();
        boolean bl = model.field_178720_f.field_78806_j = armorSlot == EquipmentSlotType.HEAD;
        if (_default != null) {
            model.field_217114_e = _default.field_217114_e;
            model.field_228270_o_ = _default.field_228270_o_;
            model.field_217113_d = _default.field_217113_d;
            model.field_187076_m = _default.field_187076_m;
            model.field_187075_l = _default.field_187075_l;
        }
        return (A)((Object)model);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        String s = TextFormatting.func_110646_a((String)stack.func_200301_q().getString());
        boolean wadoo = stack.func_82837_s() && s != null && s.equals("Wadoo");
        return new ResourceLocation("mowziesmobs", "textures/entity/barakoa_" + this.type.name + (wadoo ? "_wadoo" : "") + ".png").toString();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".text.0").func_230530_a_(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".text.1").func_230530_a_(ItemHandler.TOOLTIP_STYLE));
    }

    @Override
    public ConfigHandler.ArmorConfig getConfig() {
        return ConfigHandler.COMMON.TOOLS_AND_ABILITIES.BARAKOA_MASK.armorConfig;
    }

    private static class BarakoaMaskMaterial
    implements IArmorMaterial {
        private BarakoaMaskMaterial() {
        }

        public int func_200896_a(EquipmentSlotType equipmentSlotType) {
            return ArmorMaterial.LEATHER.func_200896_a(equipmentSlotType);
        }

        public int func_200902_b(EquipmentSlotType equipmentSlotType) {
            return (Integer)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.BARAKOA_MASK.armorConfig.damageReduction.get();
        }

        public int func_200900_a() {
            return ArmorMaterial.LEATHER.func_200900_a();
        }

        public SoundEvent func_200899_b() {
            return ArmorMaterial.LEATHER.func_200899_b();
        }

        public Ingredient func_200898_c() {
            return null;
        }

        public String func_200897_d() {
            return "barakoa_mask";
        }

        public float func_200901_e() {
            return ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.BARAKOA_MASK.armorConfig.toughness.get()).floatValue();
        }

        public float func_230304_f_() {
            return ArmorMaterial.LEATHER.func_230304_f_();
        }
    }
}

