/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import slimeknights.mantle.network.packet.IThreadsafePacket;

public class InventorySlotSyncPacket
implements IThreadsafePacket {
    public final ItemStack itemStack;
    public final int slot;
    public final BlockPos pos;

    public InventorySlotSyncPacket(ItemStack itemStack, int slot, BlockPos pos) {
        this.itemStack = itemStack;
        this.slot = slot;
        this.pos = pos;
    }

    public InventorySlotSyncPacket(PacketBuffer buffer) {
        this.itemStack = buffer.func_150791_c();
        this.slot = buffer.readShort();
        this.pos = buffer.func_179259_c();
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.func_150788_a(this.itemStack);
        packetBuffer.writeShort(this.slot);
        packetBuffer.func_179255_a(this.pos);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(InventorySlotSyncPacket packet) {
            TileEntity te;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (te = world.func_175625_s(packet.pos)) != null) {
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(cap -> cap instanceof IItemHandlerModifiable).ifPresent(cap -> {
                    ((IItemHandlerModifiable)cap).setStackInSlot(packet.slot, packet.itemStack);
                    Minecraft.func_71410_x().field_71438_f.func_184376_a(null, packet.pos, null, null, 0);
                });
            }
        }
    }
}

