/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.entitymelting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.EntityIngredient;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class EntityMeltingRecipeBuilder
extends AbstractRecipeBuilder<EntityMeltingRecipeBuilder> {
    private final EntityIngredient ingredient;
    private final FluidStack output;
    private final int damage;

    public static EntityMeltingRecipeBuilder melting(EntityIngredient ingredient, FluidStack output) {
        return EntityMeltingRecipeBuilder.melting(ingredient, output, 2);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, Objects.requireNonNull(this.output.getFluid().getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "entity_melting");
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId));
    }

    private EntityMeltingRecipeBuilder(EntityIngredient ingredient, FluidStack output, int damage) {
        this.ingredient = ingredient;
        this.output = output;
        this.damage = damage;
    }

    public static EntityMeltingRecipeBuilder melting(EntityIngredient ingredient, FluidStack output, int damage) {
        return new EntityMeltingRecipeBuilder(ingredient, output, damage);
    }

    private class FinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)EntityMeltingRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            json.add("entity", EntityMeltingRecipeBuilder.this.ingredient.serialize());
            json.add("result", (JsonElement)RecipeHelper.serializeFluidStack((FluidStack)EntityMeltingRecipeBuilder.this.output));
            json.addProperty("damage", (Number)EntityMeltingRecipeBuilder.this.damage);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerSmeltery.entityMeltingSerializer.get();
        }
    }
}

