/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.severing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.EntityIngredient;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;

public class AgeableSeveringRecipe
extends SeveringRecipe {
    @Nullable
    private final ItemOutput childOutput;

    public AgeableSeveringRecipe(ResourceLocation id, EntityIngredient ingredient, ItemOutput adultOutput, @Nullable ItemOutput childOutput) {
        super(id, ingredient, adultOutput);
        this.childOutput = childOutput;
    }

    @Override
    public ItemStack getOutput(Entity entity) {
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_70631_g_()) {
            return this.childOutput == null ? ItemStack.field_190927_a : this.childOutput.get().func_77946_l();
        }
        return this.getOutput().func_77946_l();
    }

    public static class Serializer
    extends LoggingRecipeSerializer<AgeableSeveringRecipe> {
        public AgeableSeveringRecipe read(ResourceLocation id, JsonObject json) {
            EntityIngredient ingredient = EntityIngredient.deserialize((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"entity"));
            ItemOutput adult = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"adult_result"));
            ItemOutput child = null;
            if (json.has("child_result")) {
                child = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"child_result"));
            }
            return new AgeableSeveringRecipe(id, ingredient, adult, child);
        }

        @Override
        @Nullable
        protected AgeableSeveringRecipe readSafe(ResourceLocation id, PacketBuffer buffer) {
            EntityIngredient ingredient = EntityIngredient.read((PacketBuffer)buffer);
            ItemOutput adult = ItemOutput.read((PacketBuffer)buffer);
            ItemOutput child = null;
            if (buffer.readBoolean()) {
                child = ItemOutput.read((PacketBuffer)buffer);
            }
            return new AgeableSeveringRecipe(id, ingredient, adult, child);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, AgeableSeveringRecipe recipe) {
            recipe.ingredient.write(buffer);
            recipe.output.write(buffer);
            if (recipe.childOutput == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                recipe.childOutput.write(buffer);
            }
        }
    }
}

