/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffectLoader;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;

public class EffectSpillingEffect
implements ISpillingEffect {
    public static final Loader LOADER = new Loader();
    private final Effect effect;
    private final int time;
    private final int level;

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        int time;
        LivingEntity target = context.getLivingTarget();
        if (target != null && (time = (int)((float)(this.time * 20) * scale)) > 0) {
            target.func_195064_c(new EffectInstance(this.effect, time, this.level - 1));
        }
    }

    @Override
    public ISpillingEffectLoader<?> getLoader() {
        return LOADER;
    }

    public EffectSpillingEffect(Effect effect, int time, int level) {
        this.effect = effect;
        this.time = time;
        this.level = level;
    }

    private static class Loader
    implements ISpillingEffectLoader<EffectSpillingEffect> {
        private Loader() {
        }

        @Override
        public EffectSpillingEffect deserialize(JsonObject json) {
            ResourceLocation id = JsonHelper.getResourceLocation((JsonObject)json, (String)"name");
            if (!ForgeRegistries.POTIONS.containsKey(id)) {
                throw new JsonSyntaxException("Unknown effect " + id);
            }
            Effect effect = (Effect)Objects.requireNonNull(ForgeRegistries.POTIONS.getValue(id));
            int time = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            int level = JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1);
            return new EffectSpillingEffect(effect, time, level);
        }

        @Override
        public EffectSpillingEffect read(PacketBuffer buffer) {
            Effect effect = (Effect)buffer.readRegistryIdUnsafe(ForgeRegistries.POTIONS);
            int level = buffer.func_150792_a();
            int time = buffer.func_150792_a();
            return new EffectSpillingEffect(effect, time, level);
        }

        @Override
        public void serialize(EffectSpillingEffect effect, JsonObject json) {
            json.addProperty("name", Objects.requireNonNull(effect.effect.getRegistryName()).toString());
            json.addProperty("time", (Number)effect.time);
            json.addProperty("level", (Number)effect.level);
        }

        @Override
        public void write(EffectSpillingEffect effect, PacketBuffer buffer) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.POTIONS, (IForgeRegistryEntry)effect.effect);
            buffer.func_150787_b(effect.time);
            buffer.func_150787_b(effect.level);
        }
    }
}

