/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import net.minecraft.entity.LivingEntity;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.events.teleport.SpillingTeleportEvent;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffectLoader;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.utils.TeleportHelper;

public class TeleportSpillingEffect
implements ISpillingEffect {
    public static final TeleportSpillingEffect INSTANCE = new TeleportSpillingEffect();
    public static final ISpillingEffectLoader.Singleton<TeleportSpillingEffect> LOADER = new ISpillingEffectLoader.Singleton<TeleportSpillingEffect>(INSTANCE);
    private static final TeleportHelper.ITeleportEventFactory TELEPORT_PREDICATE = SpillingTeleportEvent::new;

    private TeleportSpillingEffect() {
    }

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            TeleportHelper.randomNearbyTeleport(target, TELEPORT_PREDICATE);
        }
    }

    @Override
    public ISpillingEffectLoader<?> getLoader() {
        return LOADER;
    }
}

