/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import slimeknights.mantle.recipe.ICommonRecipe;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderInventory;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.tileentity.table.crafting.PartBuilderInventoryWrapper;

public interface IPartBuilderRecipe
extends ICommonRecipe<IPartBuilderInventory> {
    public Pattern getPattern();

    public int getCost();

    public boolean partialMatch(IPartBuilderInventory var1);

    default public int getItemsUsed(IPartBuilderInventory inv) {
        return Optional.ofNullable(inv.getMaterial()).map(mat -> mat.getItemsUsed(this.getCost())).orElse(1);
    }

    default public IRecipeType<?> func_222127_g() {
        return RecipeTypes.PART_BUILDER;
    }

    default public ItemStack func_222128_h() {
        return new ItemStack(TinkerTables.partBuilder);
    }

    default public ItemStack getLeftover(PartBuilderInventoryWrapper inventoryWrapper) {
        int remainder;
        int value;
        MaterialRecipe recipe = inventoryWrapper.getMaterial();
        if (recipe != null && (value = recipe.getValue()) > 1 && (remainder = value - this.getCost() % value) > 0) {
            ItemStack leftover = recipe.getLeftover();
            leftover.func_190920_e(leftover.func_190916_E() * remainder);
            return leftover;
        }
        return ItemStack.field_190927_a;
    }
}

