/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation;

import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ValidatedResult {
    public static final ValidatedResult PASS = new ValidatedResult(false);
    private final boolean success;

    public static ValidatedResult success(ItemStack result) {
        return new Success(result);
    }

    public static ValidatedResult failure(String translationKey, Object ... params) {
        return new Failure(translationKey, params);
    }

    public ItemStack getResult() {
        return ItemStack.field_190927_a;
    }

    public boolean hasError() {
        return false;
    }

    public ITextComponent getMessage() {
        throw new UnsupportedOperationException("Cannot show error message on success");
    }

    private ValidatedResult(boolean success) {
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    private static class Failure
    extends ValidatedResult {
        private final ITextComponent message;

        private Failure(String translationKey, Object[] params) {
            super(false);
            this.message = new TranslationTextComponent(translationKey, params);
        }

        @Override
        public boolean hasError() {
            return true;
        }

        @Override
        public ITextComponent getMessage() {
            return this.message;
        }
    }

    private static class Success
    extends ValidatedResult {
        private final ItemStack result;

        private Success(ItemStack result) {
            super(true);
            this.result = result;
        }

        @Override
        public ItemStack getResult() {
            return this.result;
        }
    }
}

