/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ModifierRepairRecipeSerializer;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRepairTinkerStationRecipe
implements ITinkerStationRecipe,
ModifierRepairRecipeSerializer.IModifierRepairRecipe {
    private final ResourceLocation id;
    private final Modifier modifier;
    private final Ingredient ingredient;
    private final int repairAmount;

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        if (!TinkerTags.Items.DURABILITY.func_230235_a_((Object)tinkerable.func_77973_b())) {
            return false;
        }
        ToolStack tool = ToolStack.from(tinkerable);
        if (tool.getModifierLevel(this.modifier) == 0) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationInventory inv) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        int amountPerItem = tool.getModifierLevel(this.modifier) * this.repairAmount;
        if (amountPerItem <= 0) {
            return ValidatedResult.PASS;
        }
        float repairFactor = 1.0f;
        for (ModifierEntry entry : tool.getModifierList()) {
            repairFactor = entry.getModifier().getRepairFactor(tool, entry.getLevel(), repairFactor);
            if (!(repairFactor <= 0.0f)) continue;
            return ValidatedResult.PASS;
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, amountPerItem = (int)((float)amountPerItem * repairFactor));
        if (available <= 0) {
            return ValidatedResult.PASS;
        }
        tool = tool.copy();
        ToolDamageUtil.repair(tool, available);
        return ValidatedResult.success(tool.createStack());
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationInventory inv, boolean isServer) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        float repairFactor = 1.0f;
        for (ModifierEntry entry : tool.getModifierList()) {
            repairFactor = entry.getModifier().getRepairFactor(tool, entry.getLevel(), repairFactor);
            if (!(repairFactor <= 0.0f)) continue;
            return;
        }
        int amountPerItem = (int)((float)(tool.getModifierLevel(this.modifier) * this.repairAmount) * repairFactor);
        if (amountPerItem < 0) {
            return;
        }
        int repairRemaining = tool.getDamage() - ToolStack.from(result).getDamage();
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, repairRemaining, amountPerItem, ItemStack.field_190927_a);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.modifierRepair.get();
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ModifierRepairTinkerStationRecipe(ResourceLocation id, Modifier modifier, Ingredient ingredient, int repairAmount) {
        this.id = id;
        this.modifier = modifier;
        this.ingredient = ingredient;
        this.repairAmount = repairAmount;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public Modifier getModifier() {
        return this.modifier;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getRepairAmount() {
        return this.repairAmount;
    }
}

