/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.tables.TinkerTables;

public class SpecializedRepairRecipeBuilder
extends AbstractRecipeBuilder<SpecializedRepairRecipeBuilder> {
    private final Ingredient tool;
    private final MaterialId repairMaterial;

    public static SpecializedRepairRecipeBuilder repair(IItemProvider item, MaterialId repairMaterial) {
        return SpecializedRepairRecipeBuilder.repair(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), repairMaterial);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.repairMaterial);
    }

    public SpecializedRepairRecipeBuilder buildRepairKit(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId, (IRecipeSerializer)TinkerTables.specializedRepairKitSerializer.get()));
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId, (IRecipeSerializer)TinkerTables.specializedRepairSerializer.get()));
    }

    private SpecializedRepairRecipeBuilder(Ingredient tool, MaterialId repairMaterial) {
        this.tool = tool;
        this.repairMaterial = repairMaterial;
    }

    public static SpecializedRepairRecipeBuilder repair(Ingredient tool, MaterialId repairMaterial) {
        return new SpecializedRepairRecipeBuilder(tool, repairMaterial);
    }

    private class FinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        private final IRecipeSerializer<?> serializer;

        public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID, IRecipeSerializer<?> serializer) {
            super((AbstractRecipeBuilder)SpecializedRepairRecipeBuilder.this, ID, advancementID);
            this.serializer = serializer;
        }

        public void func_218610_a(JsonObject json) {
            json.add("tool", SpecializedRepairRecipeBuilder.this.tool.func_200304_c());
            json.addProperty("repair_material", SpecializedRepairRecipeBuilder.this.repairMaterial.toString());
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }
    }
}

