/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.StatPredicate;

public class ToolPredicate
extends ItemPredicate {
    public static final ResourceLocation ID = TConstruct.getResource("tool");
    @Nullable
    protected final Item field_192496_b;
    @Nullable
    protected final ITag<Item> field_200018_b;
    protected final List<MaterialId> materials;
    protected final boolean hasUpgrades;
    protected final ModifierMatch upgrades;
    protected final ModifierMatch modifiers;
    protected final List<StatPredicate> stats;

    public boolean func_192493_a(ItemStack stack) {
        if (this.field_200018_b != null && !this.field_200018_b.func_230235_a_((Object)stack.func_77973_b())) {
            return false;
        }
        if (this.field_192496_b != null && stack.func_77973_b() != this.field_192496_b) {
            return false;
        }
        if (!stack.func_77973_b().func_206844_a(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        ToolStack tool = ToolStack.from(stack);
        block0: for (MaterialId check : this.materials) {
            for (IMaterial mat : tool.getMaterials().getMaterials()) {
                if (!mat.getIdentifier().equals((Object)check)) continue;
                continue block0;
            }
            return false;
        }
        if (this.hasUpgrades && tool.getUpgrades().isEmpty()) {
            return false;
        }
        if (this.upgrades != ModifierMatch.ALWAYS && !this.upgrades.test(tool.getUpgrades().getModifiers())) {
            return false;
        }
        if (this.modifiers != ModifierMatch.ALWAYS && !this.modifiers.test(tool.getModifierList())) {
            return false;
        }
        if (!this.stats.isEmpty()) {
            StatsNBT toolStats = tool.getStats();
            for (StatPredicate predicate : this.stats) {
                if (predicate.test(toolStats)) continue;
                return false;
            }
        }
        return true;
    }

    private static <D> JsonArray toArray(List<D> list, Function<D, JsonElement> mapper) {
        JsonArray array = new JsonArray();
        for (D data : list) {
            array.add(mapper.apply(data));
        }
        return array;
    }

    public JsonElement func_200319_a() {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        if (this.field_192496_b != null) {
            json.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.field_192496_b).toString());
        }
        if (this.field_200018_b != null) {
            json.addProperty("tag", TagCollectionManager.func_242178_a().func_241836_b().func_232975_b_(this.field_200018_b).toString());
        }
        if (!this.materials.isEmpty()) {
            json.add("materials", (JsonElement)ToolPredicate.toArray(this.materials, mat -> new JsonPrimitive(mat.toString())));
        }
        if (this.hasUpgrades) {
            json.addProperty("has_upgrades", Boolean.valueOf(this.hasUpgrades));
        }
        if (this.upgrades != ModifierMatch.ALWAYS) {
            json.add("upgrades", (JsonElement)this.upgrades.serialize());
        }
        if (this.modifiers != ModifierMatch.ALWAYS) {
            json.add("modifiers", (JsonElement)this.modifiers.serialize());
        }
        if (!this.stats.isEmpty()) {
            json.add("stats", (JsonElement)ToolPredicate.toArray(this.stats, StatPredicate::serialize));
        }
        return json;
    }

    public static ToolPredicate deserialize(JsonObject json) {
        Item item = null;
        if (json.has("item")) {
            item = (Item)RecipeHelper.deserializeItem((String)JSONUtils.func_151200_h((JsonObject)json, (String)"item"), (String)"item", Item.class);
        }
        ITag tag = null;
        if (json.has("tag")) {
            ResourceLocation tagName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
            tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(tagName);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown item tag '" + tagName + "'");
            }
        }
        List materials = Collections.emptyList();
        if (json.has("materials")) {
            materials = JsonHelper.parseList((JsonObject)json, (String)"materials", (element, key) -> new MaterialId(JSONUtils.func_151206_a((JsonElement)element, (String)key)));
        }
        boolean hasUpgrades = JSONUtils.func_151209_a((JsonObject)json, (String)"has_upgrades", (boolean)false);
        ModifierMatch upgrades = ModifierMatch.ALWAYS;
        if (json.has("upgrades")) {
            upgrades = ModifierMatch.deserialize(JSONUtils.func_152754_s((JsonObject)json, (String)"upgrades"));
        }
        ModifierMatch modifiers = ModifierMatch.ALWAYS;
        if (json.has("modifiers")) {
            modifiers = ModifierMatch.deserialize(JSONUtils.func_152754_s((JsonObject)json, (String)"modifiers"));
        }
        List stats = Collections.emptyList();
        if (json.has("stats")) {
            stats = JsonHelper.parseList((JsonObject)json, (String)"stats", StatPredicate::deserialize);
        }
        return new ToolPredicate(item, (ITag<Item>)tag, materials, hasUpgrades, upgrades, modifiers, stats);
    }

    public static Builder builder(Item item) {
        return new Builder(item, null);
    }

    public static Builder builder(ITag<Item> tag) {
        return new Builder(null, tag);
    }

    public static Builder builder() {
        return new Builder(null, null);
    }

    protected ToolPredicate(@Nullable Item item, @Nullable ITag<Item> tag, List<MaterialId> materials, boolean hasUpgrades, ModifierMatch upgrades, ModifierMatch modifiers, List<StatPredicate> stats) {
        this.field_192496_b = item;
        this.field_200018_b = tag;
        this.materials = materials;
        this.hasUpgrades = hasUpgrades;
        this.upgrades = upgrades;
        this.modifiers = modifiers;
        this.stats = stats;
    }

    public static class Builder {
        @Nullable
        protected final Item item;
        @Nullable
        protected final ITag<Item> tag;
        protected final List<MaterialId> materials = new ArrayList<MaterialId>();
        protected boolean hasUpgrades = false;
        protected ModifierMatch upgrades = ModifierMatch.ALWAYS;
        protected ModifierMatch modifiers = ModifierMatch.ALWAYS;
        protected final List<StatPredicate> stats = new ArrayList<StatPredicate>();

        protected Builder(@Nullable Item item, @Nullable ITag<Item> tag) {
            this.item = item;
            this.tag = tag;
        }

        public Builder withMaterial(MaterialId material) {
            this.materials.add(material);
            return this;
        }

        public Builder withStat(StatPredicate predicate) {
            this.stats.add(predicate);
            return this;
        }

        public ToolPredicate build() {
            return new ToolPredicate(this.item, this.tag, this.materials, this.hasUpgrades, this.upgrades, this.modifiers, this.stats);
        }

        public Builder hasUpgrades(boolean hasUpgrades) {
            this.hasUpgrades = hasUpgrades;
            return this;
        }

        public Builder upgrades(ModifierMatch upgrades) {
            this.upgrades = upgrades;
            return this;
        }

        public Builder modifiers(ModifierMatch modifiers) {
            this.modifiers = modifiers;
            return this;
        }
    }
}

