/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class EquipmentContext {
    private final LivingEntity entity;
    protected final boolean[] fetchedTool = new boolean[6];
    protected final IModifierToolStack[] toolsInSlots = new IModifierToolStack[6];
    private LazyOptional<TinkerDataCapability.Holder> tinkerData = null;

    @Nullable
    protected static IModifierToolStack getToolStackIfModifiable(ItemStack stack) {
        if (!stack.func_190926_b() && TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)stack.func_77973_b())) {
            return ToolStack.from(stack);
        }
        return null;
    }

    @Nullable
    public IModifierToolStack getToolInSlot(EquipmentSlotType slotType) {
        int index = slotType.func_188452_c();
        if (!this.fetchedTool[index]) {
            this.toolsInSlots[index] = EquipmentContext.getToolStackIfModifiable(this.entity.func_184582_a(slotType));
            this.fetchedTool[index] = true;
        }
        return this.toolsInSlots[index];
    }

    public boolean hasModifiableArmor() {
        for (EquipmentSlotType slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
            if (this.getToolInSlot(slotType) == null) continue;
            return true;
        }
        return false;
    }

    public LazyOptional<TinkerDataCapability.Holder> getTinkerData() {
        if (this.tinkerData == null) {
            this.tinkerData = this.entity.getCapability(TinkerDataCapability.CAPABILITY);
        }
        return this.tinkerData;
    }

    public EquipmentContext(LivingEntity entity) {
        this.entity = entity;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }
}

