/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.DefinitionModifierSlots;
import slimeknights.tconstruct.library.tools.definition.DefinitionToolStats;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public class ToolDefinitionData {
    @VisibleForTesting
    protected static final Stats EMPTY_STATS = new Stats(DefinitionToolStats.EMPTY, DefinitionToolStats.EMPTY);
    public static final ToolDefinitionData EMPTY = new ToolDefinitionData(Collections.emptyList(), EMPTY_STATS, DefinitionModifierSlots.EMPTY, Collections.emptyList());
    @Nullable
    private final List<PartRequirement> parts;
    @Nullable
    private final Stats stats;
    @Nullable
    private final DefinitionModifierSlots slots;
    @Nullable
    private final List<ModifierEntry> traits;

    public List<PartRequirement> getParts() {
        return (List)LogicHelper.defaultIfNull(this.parts, Collections.emptyList());
    }

    protected Stats getStats() {
        return (Stats)LogicHelper.defaultIfNull((Object)this.stats, (Object)EMPTY_STATS);
    }

    protected DefinitionModifierSlots getSlots() {
        return (DefinitionModifierSlots)LogicHelper.defaultIfNull((Object)this.slots, (Object)DefinitionModifierSlots.EMPTY);
    }

    public List<ModifierEntry> getTraits() {
        return (List)LogicHelper.defaultIfNull(this.traits, Collections.emptyList());
    }

    public int getStartingSlots(SlotType type) {
        return this.getSlots().getSlots(type);
    }

    public Set<FloatToolStat> getAllBaseStats() {
        return this.getStats().getBase().containedStats();
    }

    public float getBaseStat(FloatToolStat toolStat) {
        return this.getStats().getBase().getStat(toolStat, toolStat.getDefaultValue());
    }

    public float getBonus(FloatToolStat toolStat) {
        return this.getStats().getBase().getStat(toolStat, 0.0f);
    }

    public float getMultiplier(FloatToolStat toolStat) {
        return this.getStats().getMultipliers().getStat(toolStat, 1.0f);
    }

    public void buildStatMultipliers(ModifierStatsBuilder builder) {
        if (this.stats != null) {
            DefinitionToolStats multipliers = this.stats.getMultipliers();
            for (FloatToolStat stat : multipliers.containedStats()) {
                stat.multiplyAll(builder, multipliers.getStat(stat, 1.0f));
            }
        }
    }

    public void buildSlots(ModDataNBT persistentModData) {
        if (this.slots != null) {
            for (SlotType type : this.slots.containedTypes()) {
                persistentModData.setSlots(type, this.slots.getSlots(type));
            }
        }
    }

    public void write(PacketBuffer buffer) {
        List<PartRequirement> parts = this.getParts();
        buffer.func_150787_b(parts.size());
        for (PartRequirement part : parts) {
            part.write(buffer);
        }
        Stats stats = this.getStats();
        stats.getBase().write(buffer);
        stats.getMultipliers().write(buffer);
        this.getSlots().write(buffer);
        List<ModifierEntry> traits = this.getTraits();
        buffer.func_150787_b(traits.size());
        for (ModifierEntry entry : traits) {
            entry.write(buffer);
        }
    }

    public static ToolDefinitionData read(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        ImmutableList.Builder parts = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            parts.add((Object)PartRequirement.read(buffer));
        }
        DefinitionToolStats bonuses = DefinitionToolStats.read(buffer);
        DefinitionToolStats multipliers = DefinitionToolStats.read(buffer);
        DefinitionModifierSlots slots = DefinitionModifierSlots.read(buffer);
        size = buffer.func_150792_a();
        ImmutableList.Builder traits = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            traits.add((Object)ModifierEntry.read(buffer));
        }
        return new ToolDefinitionData((List<PartRequirement>)parts.build(), new Stats(bonuses, multipliers), slots, (List<ModifierEntry>)traits.build());
    }

    public ToolDefinitionData(@Nullable List<PartRequirement> parts, @Nullable Stats stats, @Nullable DefinitionModifierSlots slots, @Nullable List<ModifierEntry> traits) {
        this.parts = parts;
        this.stats = stats;
        this.slots = slots;
        this.traits = traits;
    }

    public static class Stats {
        @Nullable
        private final DefinitionToolStats base;
        @Nullable
        private final DefinitionToolStats multipliers;

        public DefinitionToolStats getBase() {
            return (DefinitionToolStats)LogicHelper.defaultIfNull((Object)this.base, (Object)DefinitionToolStats.EMPTY);
        }

        public DefinitionToolStats getMultipliers() {
            return (DefinitionToolStats)LogicHelper.defaultIfNull((Object)this.multipliers, (Object)DefinitionToolStats.EMPTY);
        }

        public Stats(@Nullable DefinitionToolStats base, @Nullable DefinitionToolStats multipliers) {
            this.base = base;
            this.multipliers = multipliers;
        }
    }
}

