/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.DefinitionModifierSlots;
import slimeknights.tconstruct.library.tools.definition.DefinitionToolStats;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.UpdateToolDefinitionDataPacket;

public class ToolDefinitionLoader
extends JsonReloadListener {
    private static final Logger log = LogManager.getLogger(ToolDefinitionLoader.class);
    public static final String FOLDER = "tinkering/tool_definitions";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(DefinitionToolStats.class, (Object)DefinitionToolStats.SERIALIZER).registerTypeAdapter(PartRequirement.class, (Object)PartRequirement.SERIALIZER).registerTypeAdapter(DefinitionModifierSlots.class, (Object)DefinitionModifierSlots.SERIALIZER).registerTypeAdapter(ModifierEntry.class, (Object)ModifierEntry.SERIALIZER).setPrettyPrinting().disableHtmlEscaping().create();
    private static final ToolDefinitionLoader INSTANCE = new ToolDefinitionLoader();
    private Map<ResourceLocation, ToolDefinitionData> dataMap = Collections.emptyMap();
    private final Map<ResourceLocation, ToolDefinition> definitions = new HashMap<ResourceLocation, ToolDefinition>();

    private ToolDefinitionLoader() {
        super(GSON, FOLDER);
    }

    public static ToolDefinitionLoader getInstance() {
        return INSTANCE;
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::addDataPackListeners);
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::onDatapackSync);
    }

    protected void updateDataFromServer(Map<ResourceLocation, ToolDefinitionData> dataMap) {
        this.dataMap = dataMap;
        for (Map.Entry<ResourceLocation, ToolDefinition> entry : this.definitions.entrySet()) {
            ToolDefinitionData data = dataMap.get(entry.getKey());
            ToolDefinition definition = entry.getValue();
            if (data != null) {
                definition.setData(data);
                continue;
            }
            definition.setDefaultData();
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, ToolDefinition> entry : this.definitions.entrySet()) {
            ResourceLocation key = entry.getKey();
            ToolDefinition definition = entry.getValue();
            JsonElement element = splashList.get(key);
            if (element == null) {
                log.error("Missing tool definition for tool {}", (Object)key);
                definition.setDefaultData();
                continue;
            }
            try {
                ToolDefinitionData data = (ToolDefinitionData)GSON.fromJson((JsonElement)JSONUtils.func_151210_l((JsonElement)element, (String)"tool_definition"), ToolDefinitionData.class);
                definition.validate(data);
                builder.put((Object)key, (Object)data);
                definition.setData(data);
            }
            catch (Exception e) {
                log.error("Failed to load tool definition for tool {}", (Object)key, (Object)e);
                definition.setDefaultData();
            }
        }
        this.dataMap = builder.build();
    }

    public Collection<ToolDefinition> getRegisteredToolDefinitions() {
        return this.definitions.values();
    }

    private void onDatapackSync(OnDatapackSyncEvent event) {
        UpdateToolDefinitionDataPacket packet = new UpdateToolDefinitionDataPacket(this.dataMap);
        TinkerNetwork.getInstance().sendToPlayerList(event.getPlayer(), event.getPlayerList(), packet);
    }

    private void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)this);
    }

    public void registerToolDefinition(ToolDefinition definition) {
        ResourceLocation name = definition.getId();
        if (this.definitions.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate tool definition " + name);
        }
        this.definitions.put(name, definition);
    }
}

