/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import java.util.List;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.IToolStatProvider;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStatsBuilder;
import slimeknights.tconstruct.tools.MeleeHarvestToolStatsBuilder;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public class ToolStatProviders {
    public static final IToolStatProvider NO_PARTS = new IToolStatProvider(){

        @Override
        public StatsNBT buildStats(ToolDefinition definition, List<IMaterial> materials) {
            return ToolStatsBuilder.noParts(definition).buildStats();
        }

        @Override
        public boolean isMultipart() {
            return false;
        }

        @Override
        public void validate(ToolDefinitionData data) {
            if (!data.getParts().isEmpty()) {
                throw new IllegalStateException("Cannot have parts for a specialized tool");
            }
        }
    };
    public static final IToolStatProvider MELEE_HARVEST = new IToolStatProvider(){

        @Override
        public StatsNBT buildStats(ToolDefinition definition, List<IMaterial> materials) {
            return MeleeHarvestToolStatsBuilder.from(definition, materials).buildStats();
        }

        @Override
        public boolean isMultipart() {
            return true;
        }

        @Override
        public void validate(ToolDefinitionData data) {
            List<PartRequirement> requirements = data.getParts();
            if (requirements.isEmpty()) {
                throw new IllegalStateException("Must have at least one tool part for a melee/harvest tool");
            }
            boolean foundHead = false;
            for (PartRequirement req : requirements) {
                MaterialStatsId statType = req.getStatType();
                if (statType.equals((Object)HeadMaterialStats.ID)) {
                    foundHead = true;
                    continue;
                }
                if (statType.equals((Object)HandleMaterialStats.ID) || statType.equals((Object)ExtraMaterialStats.ID)) continue;
                throw new IllegalStateException("Invalid melee/harvest tool part type, only support head, handle, and extra part types");
            }
            if (!foundHead) {
                throw new IllegalStateException("Melee/harvest tool must use at least one head part");
            }
        }
    };
}

