/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.item.ITinkerStationDisplay;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class TooltipUtil {
    public static final String KEY_DISPLAY = "tic_display";
    public static final BiPredicate<Attribute, AttributeModifier.Operation> SHOW_ALL_ATTRIBUTES = (att, op) -> true;
    public static final BiPredicate<Attribute, AttributeModifier.Operation> SHOW_MELEE_ATTRIBUTES = (att, op) -> op != AttributeModifier.Operation.ADDITION || att != Attributes.field_233823_f_ && att != Attributes.field_233825_h_;
    public static final BiPredicate<Attribute, AttributeModifier.Operation> SHOW_ARMOR_ATTRIBUTES = (att, op) -> op != AttributeModifier.Operation.ADDITION || att != Attributes.field_233826_i_ && att != Attributes.field_233827_j_ && att != Attributes.field_233820_c_;
    public static final ITextComponent TOOLTIP_HOLD_SHIFT = TConstruct.makeTranslation("tooltip", "hold_shift", TConstruct.makeTranslation("key", "shift").func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.ITALIC}));
    public static final ITextComponent TOOLTIP_HOLD_CTRL = TConstruct.makeTranslation("tooltip", "hold_ctrl", TConstruct.makeTranslation("key", "ctrl").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC}));
    private static final ITextComponent NO_DATA = TConstruct.makeTranslation("tooltip", "missing_data").func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent UNINITIALIZED = TConstruct.makeTranslation("tooltip", "uninitialized").func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent RANDOM_MATERIALS = TConstruct.makeTranslation("tooltip", "random_materials").func_240699_a_(TextFormatting.GRAY);

    private TooltipUtil() {
    }

    public static boolean isDisplay(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74767_n(KEY_DISPLAY);
    }

    public static ITextComponent getDisplayName(ItemStack stack, ToolDefinition toolDefinition) {
        return TooltipUtil.getDisplayName(stack, null, toolDefinition);
    }

    public static ITextComponent getDisplayName(ItemStack stack, @Nullable IModifierToolStack tool, ToolDefinition toolDefinition) {
        List<IMaterial> materials;
        List<PartRequirement> components = toolDefinition.getData().getParts();
        TranslationTextComponent baseName = new TranslationTextComponent(stack.func_77977_a());
        if (components.isEmpty()) {
            return baseName;
        }
        LinkedHashSet nameMaterials = Sets.newLinkedHashSet();
        if (tool == null) {
            tool = ToolStack.from(stack);
        }
        if ((materials = tool.getMaterialsList()).size() == components.size()) {
            for (int i = 0; i < components.size(); ++i) {
                if (i >= materials.size() || !MaterialRegistry.getInstance().canRepair(components.get(i).getStatType())) continue;
                nameMaterials.add(materials.get(i));
            }
        }
        return ITinkerStationDisplay.getCombinedItemName(stack, (ITextComponent)baseName, nameMaterials);
    }

    @Deprecated
    public static void addInformation(IModifiableDisplay item, ItemStack stack, List<ITextComponent> tooltip, TooltipKey tooltipKey, boolean isAdvanced) {
        TooltipUtil.addInformation(item, stack, null, tooltip, tooltipKey, isAdvanced ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addInformation(IModifiableDisplay item, ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, TooltipKey tooltipKey, ITooltipFlag tooltipFlag) {
        ClientPlayerEntity player = world == null ? null : Minecraft.func_71410_x().field_71439_g;
        TooltipUtil.addInformation(item, stack, (PlayerEntity)player, tooltip, tooltipKey, TooltipFlag.fromVanilla(tooltipFlag));
    }

    public static void addInformation(IModifiableDisplay item, ItemStack stack, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ToolDefinition definition = item.getToolDefinition();
        if (TooltipUtil.isDisplay(stack)) {
            ToolStack tool = ToolStack.from(stack);
            TooltipUtil.addModifierNames(stack, tool, tooltip);
        } else if (!definition.isDataLoaded()) {
            tooltip.add(NO_DATA);
        } else if (!ToolStack.isInitialized(stack)) {
            CompoundNBT nbt;
            tooltip.add(UNINITIALIZED);
            if (definition.isMultipart() && ((nbt = stack.func_77978_p()) == null || !nbt.func_150297_b("tic_materials", 9))) {
                tooltip.add(RANDOM_MATERIALS);
            }
        } else {
            switch (tooltipKey) {
                case SHIFT: {
                    item.getStatInformation(ToolStack.from(stack), player, tooltip, tooltipKey, tooltipFlag);
                    break;
                }
                case CONTROL: {
                    if (definition.isMultipart()) {
                        TooltipUtil.getComponents(item, stack, tooltip);
                        break;
                    }
                }
                default: {
                    ToolStack tool = ToolStack.from(stack);
                    TooltipUtil.getDefaultInfo(stack, tool, tooltip);
                    TooltipUtil.addAttributes(item, tool, player, tooltip, SHOW_ALL_ATTRIBUTES, EquipmentSlotType.values());
                }
            }
        }
    }

    public static void getDefaultInfo(ItemStack stack, List<ITextComponent> tooltips) {
        TooltipUtil.getDefaultInfo(stack, ToolStack.from(stack), tooltips);
    }

    public static void addModifierNames(ItemStack stack, IModifierToolStack tool, List<ITextComponent> tooltips) {
        CompoundNBT tag;
        for (ModifierEntry entry : tool.getModifierList()) {
            if (!entry.getModifier().shouldDisplay(false)) continue;
            tooltips.add(entry.getModifier().getDisplayName(tool, entry.getLevel()));
        }
        if (!stack.func_190926_b() && (tag = stack.func_77978_p()) != null && tag.func_150297_b("Enchantments", 9)) {
            ListNBT enchantments = tag.func_150295_c("Enchantments", 10);
            for (int i = 0; i < enchantments.size(); ++i) {
                CompoundNBT enchantmentTag = enchantments.func_150305_b(i);
                Registry.field_212628_q.func_241873_b(ResourceLocation.func_208304_a((String)enchantmentTag.func_74779_i("id"))).ifPresent(enchantment -> tooltips.add(enchantment.func_200305_d(enchantmentTag.func_74762_e("lvl"))));
            }
        }
    }

    public static void getDefaultInfo(IModifierToolStack tool, List<ITextComponent> tooltips) {
        TooltipUtil.getDefaultInfo(ItemStack.field_190927_a, tool, tooltips);
    }

    public static void getDefaultInfo(ItemStack stack, IModifierToolStack tool, List<ITextComponent> tooltips) {
        if (tool.getItem().func_77645_m() && !tool.isUnbreakable()) {
            tooltips.add(TooltipBuilder.formatDurability(tool.getCurrentDurability(), tool.getStats().getInt(ToolStats.DURABILITY), true));
        }
        TooltipUtil.addModifierNames(stack, tool, tooltips);
        tooltips.add(StringTextComponent.field_240750_d_);
        tooltips.add(TOOLTIP_HOLD_SHIFT);
        if (tool.getDefinition().isMultipart()) {
            tooltips.add(TOOLTIP_HOLD_CTRL);
        }
    }

    @Deprecated
    public static List<ITextComponent> getDefaultStats(IModifierToolStack tool, List<ITextComponent> tooltip, TooltipFlag flag) {
        return TooltipUtil.getDefaultStats(tool, null, tooltip, TooltipKey.NORMAL, flag);
    }

    public static List<ITextComponent> getDefaultStats(IModifierToolStack tool, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey key, TooltipFlag flag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltip);
        Item item = tool.getItem();
        if (TinkerTags.Items.DURABILITY.func_230235_a_((Object)item)) {
            builder.addDurability();
        }
        if (TinkerTags.Items.MELEE.func_230235_a_((Object)item)) {
            builder.addWithAttribute(ToolStats.ATTACK_DAMAGE, Attributes.field_233823_f_);
            builder.add(ToolStats.ATTACK_SPEED);
        }
        if (TinkerTags.Items.HARVEST.func_230235_a_((Object)item)) {
            if (TinkerTags.Items.HARVEST_PRIMARY.func_230235_a_((Object)tool.getItem())) {
                builder.add(ToolStats.HARVEST_LEVEL);
            }
            builder.add(ToolStats.MINING_SPEED);
        }
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getModifier().addInformation(tool, entry.getLevel(), player, tooltip, key, flag);
        }
        return builder.getTooltips();
    }

    @Deprecated
    public static List<ITextComponent> getArmorStats(IModifierToolStack tool, List<ITextComponent> tooltip, TooltipFlag flag) {
        return TooltipUtil.getArmorStats(tool, null, tooltip, TooltipKey.NORMAL, flag);
    }

    public static List<ITextComponent> getArmorStats(IModifierToolStack tool, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey key, TooltipFlag flag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltip);
        Item item = tool.getItem();
        if (TinkerTags.Items.DURABILITY.func_230235_a_((Object)item)) {
            builder.addDurability();
        }
        if (TinkerTags.Items.ARMOR.func_230235_a_((Object)item)) {
            builder.add(ToolStats.ARMOR);
            builder.addOptional(ToolStats.ARMOR_TOUGHNESS);
            builder.addOptional(ToolStats.KNOCKBACK_RESISTANCE, 10.0f);
        }
        if (TinkerTags.Items.CHESTPLATES.func_230235_a_((Object)item) && tool.getModifierLevel((Modifier)TinkerModifiers.unarmed.get()) > 0) {
            builder.addWithAttribute(ToolStats.ATTACK_DAMAGE, Attributes.field_233823_f_);
        }
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getModifier().addInformation(tool, entry.getLevel(), player, tooltip, key, flag);
        }
        return builder.getTooltips();
    }

    public static void getComponents(IModifiable item, ItemStack stack, List<ITextComponent> tooltips) {
        List<PartRequirement> components = item.getToolDefinition().getData().getParts();
        if (components.isEmpty()) {
            return;
        }
        List<IMaterial> materials = ToolStack.from(stack).getMaterialsList();
        if (materials.isEmpty()) {
            tooltips.add(NO_DATA);
            return;
        }
        if (materials.size() < components.size()) {
            return;
        }
        int max = components.size() - 1;
        for (int i = 0; i <= max; ++i) {
            PartRequirement requirement = components.get(i);
            IMaterial material = materials.get(i);
            tooltips.add((ITextComponent)requirement.nameForMaterial(material).func_230532_e_().func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(style -> style.func_240718_a_(material.getColor())));
            MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), requirement.getStatType()).ifPresent(stat -> tooltips.addAll(stat.getLocalizedInfo()));
            if (i == max) continue;
            tooltips.add(StringTextComponent.field_240750_d_);
        }
    }

    public static void addAttributes(ITinkerStationDisplay item, IModifierToolStack tool, @Nullable PlayerEntity player, List<ITextComponent> tooltip, BiPredicate<Attribute, AttributeModifier.Operation> showAttribute, EquipmentSlotType ... slots) {
        for (EquipmentSlotType slot : slots) {
            Multimap<Attribute, AttributeModifier> modifiers = item.getAttributeModifiers(tool, slot);
            if (modifiers.isEmpty()) continue;
            if (slots.length > 1) {
                tooltip.add(StringTextComponent.field_240750_d_);
                tooltip.add((ITextComponent)new TranslationTextComponent("item.modifiers." + slot.func_188450_d()).func_240699_a_(TextFormatting.GRAY));
            }
            for (Map.Entry entry : modifiers.entries()) {
                AttributeModifier modifier;
                AttributeModifier.Operation operation;
                Attribute attribute = (Attribute)entry.getKey();
                if (!showAttribute.test(attribute, operation = (modifier = (AttributeModifier)entry.getValue()).func_220375_c())) continue;
                double amount = modifier.func_111164_d();
                boolean showEquals = false;
                if (player != null) {
                    if (modifier.func_111167_a() == Item.field_111210_e) {
                        amount += player.func_233638_c_(Attributes.field_233823_f_);
                        showEquals = true;
                    } else if (modifier.func_111167_a() == Item.field_185050_h) {
                        amount += player.func_233638_c_(Attributes.field_233825_h_);
                        showEquals = true;
                    }
                }
                double displayValue = amount;
                if (modifier.func_220375_c() == AttributeModifier.Operation.ADDITION) {
                    if (attribute.equals(Attributes.field_233820_c_)) {
                        displayValue *= 10.0;
                    }
                } else {
                    displayValue *= 100.0;
                }
                TranslationTextComponent name = new TranslationTextComponent(attribute.func_233754_c_());
                if (showEquals) {
                    tooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.modifier.equals." + operation.func_220371_a(), new Object[]{ItemStack.field_111284_a.format(displayValue), name})).func_240699_a_(TextFormatting.DARK_GREEN));
                    continue;
                }
                if (amount > 0.0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + operation.func_220371_a(), new Object[]{ItemStack.field_111284_a.format(displayValue), name}).func_240699_a_(TextFormatting.BLUE));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + operation.func_220371_a(), new Object[]{ItemStack.field_111284_a.format(displayValue *= -1.0), name}).func_240699_a_(TextFormatting.RED));
            }
        }
    }
}

