/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class StatsNBT {
    private static final Set<ToolStatId> ERRORED_IDS = new HashSet<ToolStatId>();
    public static final StatsNBT EMPTY = new StatsNBT(ImmutableMap.of());
    private final ImmutableMap<IToolStat<?>, Float> stats;

    public Set<IToolStat<?>> getContainedStats() {
        return this.stats.keySet();
    }

    public boolean hasStat(IToolStat<?> stat) {
        return this.stats.containsKey(stat);
    }

    public float getFloat(IToolStat<?> stat) {
        return ((Float)this.stats.getOrDefault(stat, (Object)Float.valueOf(stat.getDefaultValue()))).floatValue();
    }

    public int getInt(IToolStat<?> stat) {
        return ((Float)this.stats.getOrDefault(stat, (Object)Float.valueOf(stat.getDefaultValue()))).intValue();
    }

    public static StatsNBT readFromNBT(@Nullable INBT inbt) {
        if (inbt == null || inbt.func_74732_a() != 10) {
            return EMPTY;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        CompoundNBT nbt = (CompoundNBT)inbt;
        for (String key : nbt.func_150296_c()) {
            ToolStatId statName;
            if (!nbt.func_150297_b(key, 99) || (statName = ToolStatId.tryCreate(key)) == null) continue;
            IToolStat<?> stat = ToolStats.getToolStat(statName);
            if (stat != null) {
                builder.put(stat, (Object)Float.valueOf(nbt.func_74760_g(key)));
                continue;
            }
            if (ERRORED_IDS.contains((Object)statName)) continue;
            ERRORED_IDS.add(statName);
            TConstruct.LOG.error("Ignoring unknown stat " + (Object)((Object)statName) + " in tool stat NBT");
        }
        return new StatsNBT(builder.build());
    }

    public CompoundNBT serializeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        for (Map.Entry entry : this.stats.entrySet()) {
            nbt.func_74776_a(((IToolStat)entry.getKey()).getName().toString(), ((Float)entry.getValue()).floatValue());
        }
        return nbt;
    }

    public static Builder builder() {
        return new Builder();
    }

    StatsNBT(ImmutableMap<IToolStat<?>, Float> stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatsNBT)) {
            return false;
        }
        StatsNBT other = (StatsNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableMap<IToolStat<?>, Float> this$stats = this.stats;
        ImmutableMap<IToolStat<?>, Float> other$stats = other.stats;
        return !(this$stats == null ? other$stats != null : !this$stats.equals(other$stats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatsNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableMap<IToolStat<?>, Float> $stats = this.stats;
        result = result * 59 + ($stats == null ? 43 : $stats.hashCode());
        return result;
    }

    public String toString() {
        return "StatsNBT(stats=" + this.stats + ")";
    }

    public static class Builder {
        private final ImmutableMap.Builder<IToolStat<?>, Float> builder = ImmutableMap.builder();

        public Builder set(IToolStat<?> stat, float value) {
            this.builder.put(stat, (Object)Float.valueOf(stat.clamp(value)));
            return this;
        }

        public StatsNBT build() {
            return new StatsNBT(this.builder.build());
        }

        private Builder() {
        }
    }
}

