/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;

public class MeltingFuelHandler {
    private static List<Pair<Integer, List<FluidStack>>> fuelLookup = Collections.emptyList();
    private static Map<Fluid, Integer> temperatureLookup = Collections.emptyMap();
    public static final Lazy<List<ItemStack>> SOLID_FUELS = Lazy.of(() -> Arrays.asList(new ItemStack((IItemProvider)Items.field_151044_h), new ItemStack((IItemProvider)Items.field_196155_l), new ItemStack((IItemProvider)Blocks.field_196617_K), new ItemStack((IItemProvider)Blocks.field_196662_n), new ItemStack((IItemProvider)Items.field_151072_bj)));

    public static void setMeltngFuels(List<MeltingFuel> fuels) {
        fuels.sort(Comparator.comparingInt(MeltingFuel::getTemperature));
        fuelLookup = fuels.stream().mapToInt(MeltingFuel::getTemperature).distinct().mapToObj(temperature -> Pair.of((Object)temperature, fuels.stream().filter(fuel -> fuel.getTemperature() >= temperature).flatMap(fuel -> fuel.getInputs().stream()).collect(Collectors.toList()))).collect(Collectors.toList());
        temperatureLookup = fuels.stream().collect(HashMap::new, (map, fuel) -> {
            int temperature = fuel.getTemperature();
            fuel.getInputs().forEach(fluid -> map.put(fluid.getFluid(), temperature));
        }, Map::putAll);
    }

    public static List<FluidStack> getUsableFuels(int temperature) {
        for (Pair<Integer, List<FluidStack>> pair : fuelLookup) {
            if (temperature > (Integer)pair.getFirst()) continue;
            return (List)pair.getSecond();
        }
        return Collections.emptyList();
    }

    public static OptionalInt getTemperature(Fluid fluid) {
        Integer temperature = temperatureLookup.get(fluid);
        if (temperature != null) {
            return OptionalInt.of(temperature);
        }
        return OptionalInt.empty();
    }
}

