/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableInt;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRequirements;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;
import slimeknights.tconstruct.shared.command.argument.ModifierArgument;

public class ModifiersCommand {
    private static final String ADD_SUCCESS = TConstruct.makeTranslationKey("command", "modifiers.success.add.single");
    private static final String ADD_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "modifiers.success.add.multiple");
    private static final String REMOVE_SUCCESS = TConstruct.makeTranslationKey("command", "modifiers.success.remove.single");
    private static final String REMOVE_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "modifiers.success.remove.multiple");
    private static final DynamicCommandExceptionType MODIFIER_ERROR = new DynamicCommandExceptionType(error -> (ITextComponent)error);
    private static final Dynamic2CommandExceptionType CANNOT_REMOVE = new Dynamic2CommandExceptionType((name, entity) -> TConstruct.makeTranslation("command", "modifiers.failure.too_few_levels", name, entity));

    public static void register(LiteralArgumentBuilder<CommandSource> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).then(Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"modifier", (ArgumentType)ModifierArgument.modifier()).executes(context -> ModifiersCommand.add((CommandContext<CommandSource>)context, 1))).then(Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ModifiersCommand.add((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))))).then(Commands.func_197057_a((String)"remove").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"modifier", (ArgumentType)ModifierArgument.modifier()).executes(context -> ModifiersCommand.remove((CommandContext<CommandSource>)context, -1))).then(Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ModifiersCommand.remove((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))));
    }

    private static int add(CommandContext<CommandSource> context, int level) throws CommandSyntaxException {
        Modifier modifier = ModifierArgument.getModifier(context, "modifier");
        List<LivingEntity> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            ToolStack tool = ToolStack.from(stack);
            int currentLevel = tool.getModifierLevel(modifier);
            List<ModifierEntry> modifiers = tool.getModifierList();
            for (ModifierRequirements requirements : ModifierRecipeLookup.getRequirements(modifier)) {
                ValidatedResult result = requirements.check(stack, level + currentLevel, modifiers);
                if (!result.hasError()) continue;
                throw MODIFIER_ERROR.create((Object)result.getMessage());
            }
            tool = tool.copy();
            tool.addModifier(modifier, level);
            ValidatedResult toolValidation = tool.validate();
            if (toolValidation.hasError()) {
                throw MODIFIER_ERROR.create((Object)toolValidation.getMessage());
            }
            living.func_184611_a(Hand.MAIN_HAND, tool.createStack());
            return true;
        });
        CommandSource source = (CommandSource)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(ADD_SUCCESS, new Object[]{modifier.getDisplayName(level), successes.get(0).func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(ADD_SUCCESS_MULTIPLE, new Object[]{modifier.getDisplayName(level), size}), true);
        }
        return size;
    }

    private static int remove(CommandContext<CommandSource> context, int level) throws CommandSyntaxException {
        Modifier modifier = ModifierArgument.getModifier(context, "modifier");
        MutableInt maxRemove = new MutableInt(1);
        List<LivingEntity> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            int removeLevel;
            ToolStack tool = ToolStack.from(stack);
            int currentLevel = tool.getUpgrades().getLevel(modifier);
            if (currentLevel == 0) {
                throw CANNOT_REMOVE.create((Object)modifier.getDisplayName(level), (Object)living.func_200200_C_());
            }
            int n = removeLevel = level == -1 ? currentLevel : level;
            if (removeLevel > maxRemove.intValue()) {
                maxRemove.setValue(removeLevel);
            }
            tool = tool.copy();
            int newLevel = currentLevel - removeLevel;
            if (newLevel <= 0) {
                modifier.beforeRemoved(tool, tool.getRestrictedNBT());
            }
            tool.removeModifier(modifier, removeLevel);
            ValidatedResult validated = tool.validate();
            if (validated.hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            if (newLevel <= 0) {
                modifier.onRemoved(tool);
            }
            if (newLevel <= 0 && (validated = modifier.validate(tool, 0)).hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            ItemStack resultStack = tool.createStack();
            validated = ModifierRecipeLookup.checkRequirements(resultStack, tool);
            if (validated.hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            living.func_184611_a(Hand.MAIN_HAND, tool.createStack());
            return true;
        });
        CommandSource source = (CommandSource)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(REMOVE_SUCCESS, new Object[]{modifier.getDisplayName(maxRemove.intValue()), successes.get(0).func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(REMOVE_SUCCESS_MULTIPLE, new Object[]{modifier.getDisplayName(maxRemove.intValue()), size}), true);
        }
        return size;
    }
}

