/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;
import slimeknights.tconstruct.shared.command.argument.SlotTypeArgument;

public class SlotsCommand {
    private static final String ADD_SUCCESS = TConstruct.makeTranslationKey("command", "slots.success.add.single");
    private static final String ADD_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "slots.success.add.multiple");
    private static final String SET_SUCCESS = TConstruct.makeTranslationKey("command", "slots.success.set.single");
    private static final String SET_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "slots.success.set.multiple");
    private static final SimpleCommandExceptionType INVALID_SLOT_COUNT = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "slots.failure.invalid_count"));
    private static final DynamicCommandExceptionType VALIDATION_ERROR = new DynamicCommandExceptionType(error -> (ITextComponent)error);

    public static void register(LiteralArgumentBuilder<CommandSource> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).then(Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"slot_type", (ArgumentType)SlotTypeArgument.slotType(false)).executes(context -> SlotsCommand.run((CommandContext<CommandSource>)context, Operation.ADD, 1))).then(Commands.func_197056_a((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(context -> SlotsCommand.run((CommandContext<CommandSource>)context, Operation.ADD)))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"slot_type", (ArgumentType)SlotTypeArgument.slotType(false)).then(Commands.func_197056_a((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> SlotsCommand.run((CommandContext<CommandSource>)context, Operation.SET))))));
    }

    private static int run(CommandContext<CommandSource> context, Operation op) throws CommandSyntaxException {
        return SlotsCommand.run(context, op, IntegerArgumentType.getInteger(context, (String)"count"));
    }

    private static int run(CommandContext<CommandSource> context, Operation op, int count) throws CommandSyntaxException {
        if (count == 0 && op != Operation.SET) {
            throw INVALID_SLOT_COUNT.create();
        }
        SlotType slotType = SlotTypeArgument.getSlotType(context, "slot_type");
        List<LivingEntity> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            ToolStack tool = ToolStack.copyFrom(stack);
            ModDataNBT slots = tool.getPersistentData();
            if (op == Operation.ADD) {
                slots.addSlots(slotType, count);
            } else {
                slots.addSlots(slotType, count - tool.getFreeSlots(slotType));
            }
            tool.rebuildStats();
            ValidatedResult toolValidation = tool.validate();
            if (toolValidation.hasError()) {
                throw VALIDATION_ERROR.create((Object)toolValidation.getMessage());
            }
            living.func_184611_a(Hand.MAIN_HAND, tool.createStack());
            return true;
        });
        CommandSource source = (CommandSource)context.getSource();
        int size = successes.size();
        if (op == Operation.ADD) {
            if (size == 1) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent(ADD_SUCCESS, new Object[]{count, slotType.getDisplayName(), successes.get(0).func_145748_c_()}), true);
            } else {
                source.func_197030_a((ITextComponent)new TranslationTextComponent(ADD_SUCCESS_MULTIPLE, new Object[]{count, slotType.getDisplayName(), size}), true);
            }
        } else if (size == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(SET_SUCCESS, new Object[]{slotType.getDisplayName(), count, successes.get(0).func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(SET_SUCCESS_MULTIPLE, new Object[]{slotType.getDisplayName(), count, size}), true);
        }
        return size;
    }

    private static enum Operation {
        ADD,
        SET;

    }
}

