/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.particle;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.Codec;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class FluidParticleData
implements IParticleData {
    private static final DynamicCommandExceptionType UNKNOWN_FLUID = new DynamicCommandExceptionType(arg -> new TranslationTextComponent("command.tconstruct.fluid.not_found", new Object[]{arg}));
    private static final IParticleData.IDeserializer<FluidParticleData> DESERIALIZER = new IParticleData.IDeserializer<FluidParticleData>(){

        public FluidParticleData deserialize(ParticleType<FluidParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int i = reader.getCursor();
            ResourceLocation id = ResourceLocation.func_195826_a((StringReader)reader);
            Fluid fluid = (Fluid)Registry.field_212619_h.func_241873_b(id).orElseThrow(() -> {
                reader.setCursor(i);
                return UNKNOWN_FLUID.createWithContext((ImmutableStringReader)reader, (Object)id.toString());
            });
            CompoundNBT nbt = null;
            if (reader.canRead() && reader.peek() == '{') {
                nbt = new JsonToNBT(reader).func_193593_f();
            }
            return new FluidParticleData(type, new FluidStack(fluid, 1000, nbt));
        }

        public FluidParticleData read(ParticleType<FluidParticleData> type, PacketBuffer buffer) {
            return new FluidParticleData(type, FluidStack.readFromPacket((PacketBuffer)buffer));
        }
    };
    private final ParticleType<FluidParticleData> type;
    private final FluidStack fluid;

    public void func_197553_a(PacketBuffer buffer) {
        this.fluid.writeToPacket(buffer);
    }

    public String func_197555_a() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.func_197554_b().getRegistryName());
        builder.append(" ");
        builder.append(this.fluid.getFluid().getRegistryName());
        CompoundNBT nbt = this.fluid.getTag();
        if (nbt != null) {
            builder.append(nbt);
        }
        return builder.toString();
    }

    public FluidParticleData(ParticleType<FluidParticleData> type, FluidStack fluid) {
        this.type = type;
        this.fluid = fluid;
    }

    public ParticleType<FluidParticleData> func_197554_b() {
        return this.type;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public static class Type
    extends ParticleType<FluidParticleData> {
        public Type() {
            super(false, DESERIALIZER);
        }

        public Codec<FluidParticleData> func_230522_e_() {
            return FluidStack.CODEC.xmap(fluid -> new FluidParticleData(this, (FluidStack)fluid), data -> ((FluidParticleData)data).fluid);
        }
    }
}

