/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.controller;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.mantle.tileentity.NamableTileEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.MelterBlock;
import slimeknights.tconstruct.smeltery.inventory.MelterContainer;
import slimeknights.tconstruct.smeltery.tileentity.ITankTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.FuelModule;
import slimeknights.tconstruct.smeltery.tileentity.module.MeltingModuleInventory;

public class MelterTileEntity
extends NamableTileEntity
implements ITankTileEntity,
ITickableTileEntity {
    private static final int TANK_CAPACITY = 1296;
    private static final String TAG_FUEL = "fuel";
    private static final String TAG_TEMPERATURE = "temperature";
    private static final String TAG_INVENTORY = "inventory";
    protected final FluidTankAnimated tank = new FluidTankAnimated(1296, (MantleTileEntity)this);
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    private final IModelData modelData = new SinglePropertyData(ModelProperties.FLUID_TANK, (Object)this.tank);
    private int lastStrength = -1;
    private int tick;
    private final MeltingModuleInventory meltingInventory = new MeltingModuleInventory((MantleTileEntity)this, (IFluidHandler)this.tank, () -> Config.COMMON.melterNuggetsPerOre.get(), 3);
    private final LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.meltingInventory);
    private final FuelModule fuelModule = new FuelModule((MantleTileEntity)this, () -> Collections.singletonList(this.field_174879_c.func_177977_b()));

    public MelterTileEntity() {
        this((TileEntityType<? extends MelterTileEntity>)((TileEntityType)TinkerSmeltery.melter.get()));
    }

    protected MelterTileEntity(TileEntityType<? extends MelterTileEntity> type) {
        super(type, (ITextComponent)TConstruct.makeTranslation("gui", "melter"));
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inv, PlayerEntity playerEntity) {
        return new MelterContainer(id, inv, this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankHolder.cast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHolder.cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.tankHolder.invalidate();
        this.inventoryHolder.invalidate();
    }

    private boolean isFormed() {
        BlockState state = this.func_195044_w();
        return state.func_235901_b_((Property)MelterBlock.IN_STRUCTURE) && (Boolean)state.func_177229_b((Property)MelterBlock.IN_STRUCTURE) != false;
    }

    public void func_73660_a() {
        if (!this.isServerWorld()) {
            return;
        }
        if (this.isFormed()) {
            switch (this.tick) {
                case 0: {
                    if (!this.fuelModule.hasFuel() && this.meltingInventory.canHeat(this.fuelModule.findFuel(false))) {
                        this.fuelModule.findFuel(true);
                    }
                }
                case 2: {
                    assert (this.field_145850_b != null);
                    BlockState state = this.func_195044_w();
                    boolean hasFuel = this.fuelModule.hasFuel();
                    if ((Boolean)state.func_177229_b((Property)ControllerBlock.ACTIVE) != hasFuel) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                        BlockPos down = this.field_174879_c.func_177977_b();
                        BlockState downState = this.field_145850_b.func_180495_p(down);
                        if (TinkerTags.Blocks.FUEL_TANKS.func_230235_a_((Object)downState.func_177230_c()) && downState.func_235901_b_((Property)ControllerBlock.ACTIVE) && (Boolean)downState.func_177229_b((Property)ControllerBlock.ACTIVE) != hasFuel) {
                            this.field_145850_b.func_175656_a(down, (BlockState)downState.func_206870_a((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                        }
                    }
                    if (hasFuel) {
                        this.meltingInventory.heatItems(this.fuelModule.getTemperature());
                        this.fuelModule.decreaseFuel(1);
                        break;
                    }
                    this.meltingInventory.coolItems();
                }
            }
            this.tick = (this.tick + 1) % 4;
        }
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.fuelModule.readFromNBT(tag);
        if (tag.func_150297_b(TAG_INVENTORY, 10)) {
            this.meltingInventory.readFromNBT(tag.func_74775_l(TAG_INVENTORY));
        }
    }

    public void writeSynced(CompoundNBT tag) {
        super.writeSynced(tag);
        tag.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        tag.func_218657_a(TAG_INVENTORY, (INBT)this.meltingInventory.writeToNBT());
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.fuelModule.writeToNBT(tag);
        return tag;
    }

    private boolean isServerWorld() {
        return this.func_145831_w() != null && !this.func_145831_w().field_72995_K;
    }

    @Override
    public FluidTankAnimated getTank() {
        return this.tank;
    }

    public IModelData getModelData() {
        return this.modelData;
    }

    @Override
    public int getLastStrength() {
        return this.lastStrength;
    }

    @Override
    public void setLastStrength(int lastStrength) {
        this.lastStrength = lastStrength;
    }

    public MeltingModuleInventory getMeltingInventory() {
        return this.meltingInventory;
    }

    public FuelModule getFuelModule() {
        return this.fuelModule;
    }
}

