/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.network;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.util.TileEntityHelper;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.tables.client.inventory.table.TinkerStationScreen;
import slimeknights.tconstruct.tables.tileentity.table.TinkerStationTileEntity;

public class UpdateTinkerStationRecipePacket
implements IThreadsafePacket {
    private final BlockPos pos;
    private final ResourceLocation recipe;

    public UpdateTinkerStationRecipePacket(BlockPos pos, ITinkerStationRecipe recipe) {
        this.pos = pos;
        this.recipe = recipe.func_199560_c();
    }

    public UpdateTinkerStationRecipePacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.recipe = buffer.func_192575_l();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_192572_a(this.recipe);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(UpdateTinkerStationRecipePacket packet) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null) {
                TinkerStationScreen stationScreen;
                TinkerStationTileEntity te2;
                Optional recipe = RecipeHelper.getRecipe((RecipeManager)world.func_199532_z(), (ResourceLocation)packet.recipe, ITinkerStationRecipe.class);
                boolean handled = false;
                Screen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof TinkerStationScreen && (te2 = (TinkerStationTileEntity)(stationScreen = (TinkerStationScreen)screen).getTileEntity()).func_174877_v().equals((Object)packet.pos)) {
                    recipe.ifPresent(te2::updateRecipe);
                    stationScreen.updateDisplay();
                    handled = true;
                }
                if (!handled) {
                    TileEntityHelper.getTile(TinkerStationTileEntity.class, (IBlockReader)world, (BlockPos)packet.pos).ifPresent(te -> recipe.ifPresent(te::updateRecipe));
                }
            }
        }
    }
}

