/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.tileentity.table;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import slimeknights.tconstruct.common.SoundUtils;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.shared.inventory.ConfigurableInvWrapperCapability;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.inventory.table.tinkerstation.TinkerStationContainer;
import slimeknights.tconstruct.tables.network.UpdateTinkerStationRecipePacket;
import slimeknights.tconstruct.tables.tileentity.table.RetexturedTableTileEntity;
import slimeknights.tconstruct.tables.tileentity.table.crafting.LazyResultInventory;
import slimeknights.tconstruct.tables.tileentity.table.crafting.TinkerStationInventoryWrapper;

public class TinkerStationTileEntity
extends RetexturedTableTileEntity
implements LazyResultInventory.ILazyCrafter {
    public static final int TINKER_SLOT = 0;
    public static final int INPUT_SLOT = 1;
    @Nullable
    private ITinkerStationRecipe lastRecipe;
    private final LazyResultInventory craftingResult;
    private final TinkerStationInventoryWrapper inventoryWrapper;
    private ValidatedResult currentError = ValidatedResult.PASS;

    public TinkerStationTileEntity() {
        this(6);
    }

    public TinkerStationTileEntity(int slots) {
        super((TileEntityType)TinkerTables.tinkerStationTile.get(), "gui.tconstruct.tinker_station", slots);
        this.itemHandler = new ConfigurableInvWrapperCapability((IInventory)this, false, false);
        this.itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
        this.inventoryWrapper = new TinkerStationInventoryWrapper(this);
        this.craftingResult = new LazyResultInventory(this);
    }

    public ITextComponent getDefaultName() {
        if (this.field_145850_b == null) {
            return super.getDefaultName();
        }
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    public int getInputCount() {
        return this.func_70302_i_() - 1;
    }

    public void resize(int size) {
        super.resize(size);
        this.inventoryWrapper.resize();
    }

    @Nullable
    public Container createMenu(int menuId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new TinkerStationContainer(menuId, playerInventory, this);
    }

    @Override
    public ItemStack calcResult(@Nullable PlayerEntity player) {
        if (this.field_145850_b == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = ItemStack.field_190927_a;
        this.currentError = ValidatedResult.PASS;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_73046_m() != null) {
            RecipeManager manager = this.field_145850_b.func_73046_m().func_199529_aN();
            ITinkerStationRecipe recipe = this.lastRecipe;
            if (recipe == null || !recipe.matches(this.inventoryWrapper, this.field_145850_b)) {
                recipe = manager.func_215371_a(RecipeTypes.TINKER_STATION, (IInventory)this.inventoryWrapper, this.field_145850_b).orElse(null);
            }
            boolean needsSync = true;
            if (recipe != null) {
                ValidatedResult validatedResult;
                if (this.lastRecipe != recipe) {
                    this.lastRecipe = recipe;
                    this.syncToRelevantPlayers(this::syncRecipe);
                    needsSync = false;
                }
                if ((validatedResult = recipe.getValidatedResult(this.inventoryWrapper)).isSuccess()) {
                    result = validatedResult.getResult();
                } else if (validatedResult.hasError()) {
                    this.currentError = validatedResult;
                }
            }
            if (needsSync) {
                this.syncToRelevantPlayers(this::syncScreen);
            }
        } else if (this.lastRecipe != null && this.lastRecipe.matches(this.inventoryWrapper, this.field_145850_b)) {
            ValidatedResult validatedResult = this.lastRecipe.getValidatedResult(this.inventoryWrapper);
            if (validatedResult.isSuccess()) {
                result = validatedResult.getResult();
            } else if (validatedResult.hasError()) {
                this.currentError = validatedResult;
            }
        }
        return result;
    }

    @Override
    public ItemStack onCraft(PlayerEntity player, ItemStack result, int amount) {
        if (amount == 0 || this.lastRecipe == null || this.field_145850_b == null) {
            return ItemStack.field_190927_a;
        }
        result.func_77980_a(this.field_145850_b, player, amount);
        BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)result, (IInventory)this.inventoryWrapper);
        this.playCraftSound(player);
        this.inventoryWrapper.setPlayer(player);
        this.lastRecipe.updateInputs(result, this.inventoryWrapper, !this.field_145850_b.field_72995_K);
        this.inventoryWrapper.setPlayer(null);
        if (this.isStackInSlot(0)) {
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
        return result;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        this.craftingResult.func_174888_l();
        this.inventoryWrapper.refreshInput(slot);
    }

    @Override
    protected void playCraftSound(PlayerEntity player) {
        SoundUtils.playSoundForAll((Entity)player, this.getInputCount() > 4 ? SoundEvents.field_187698_i : Sounds.SAW.getSound(), 0.8f, 0.8f + 0.4f * player.func_130014_f_().field_73012_v.nextFloat());
    }

    public void syncRecipe(PlayerEntity player) {
        if (this.lastRecipe != null && this.field_145850_b != null && !this.field_145850_b.field_72995_K && player instanceof ServerPlayerEntity) {
            TinkerNetwork.getInstance().sendTo(new UpdateTinkerStationRecipePacket(this.field_174879_c, this.lastRecipe), (ServerPlayerEntity)player);
        }
    }

    public void updateRecipe(ITinkerStationRecipe recipe) {
        this.lastRecipe = recipe;
        this.craftingResult.func_174888_l();
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT tags) {
        super.func_230337_a_(blockState, tags);
        this.inventoryWrapper.resize();
    }

    public LazyResultInventory getCraftingResult() {
        return this.craftingResult;
    }

    public ValidatedResult getCurrentError() {
        return this.currentError;
    }
}

