/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.particles.ParticleType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.model.tools.ToolModel;
import slimeknights.tconstruct.library.client.modifiers.BreakableDyedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.BreakableMaterialModifierModel;
import slimeknights.tconstruct.library.client.modifiers.BreakableModifierModel;
import slimeknights.tconstruct.library.client.modifiers.FluidModifierModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.client.modifiers.NormalModifierModel;
import slimeknights.tconstruct.library.client.modifiers.TankModifierModel;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.part.MaterialItem;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.client.ArmorModelWrapper;
import slimeknights.tconstruct.tools.client.OverslimeModifierModel;
import slimeknights.tconstruct.tools.client.PlateArmorModel;
import slimeknights.tconstruct.tools.client.SlimelytraArmorModel;
import slimeknights.tconstruct.tools.client.ToolContainerScreen;
import slimeknights.tconstruct.tools.client.particles.AxeAttackParticle;
import slimeknights.tconstruct.tools.client.particles.HammerAttackParticle;
import slimeknights.tconstruct.tools.logic.InteractionHandler;
import slimeknights.tconstruct.tools.modifiers.ability.armor.DoubleJumpModifier;
import slimeknights.tconstruct.tools.network.TinkerControlPacket;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ToolClientEvents
extends ClientEventBase {
    private static final KeyBinding HELMET_INTERACT = new KeyBinding(TConstruct.makeTranslationKey("key", "helmet_interact"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.func_197955_a((String)"key.keyboard.z"), "key.categories.gameplay");
    private static final KeyBinding LEGGINGS_INTERACT = new KeyBinding(TConstruct.makeTranslationKey("key", "leggings_interact"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.func_197955_a((String)"key.keyboard.i"), "key.categories.gameplay");
    private static boolean wasJumping = false;
    private static boolean wasHelmetInteracting = false;
    private static boolean wasLeggingsInteracting = false;

    public static void addResourceListener(IReloadableResourceManager manager) {
        ModifierModelManager.init(manager);
        manager.func_219534_a((IFutureReloadListener)PlateArmorModel.RELOAD_LISTENER);
        manager.func_219534_a((IFutureReloadListener)SlimelytraArmorModel.RELOAD_LISTENER);
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)TConstruct.getResource("material"), (IModelLoader)MaterialModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)TConstruct.getResource("tool"), (IModelLoader)ToolModel.LOADER);
    }

    @SubscribeEvent
    static void registerModifierModels(ModifierModelManager.ModifierModelRegistrationEvent event) {
        event.registerModel(TConstruct.getResource("normal"), NormalModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("breakable"), BreakableModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("overslime"), OverslimeModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("fluid"), FluidModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("tank"), TankModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("breakable_material"), BreakableMaterialModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("breakable_dyed"), BreakableDyedModifierModel.UNBAKED_INSTANCE);
    }

    @SubscribeEvent
    static void clientSetupEvent(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)TinkerTools.indestructibleItem.get()), manager -> new ItemRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        MinecraftForge.EVENT_BUS.addListener(ToolClientEvents::handleKeyBindings);
        ArmorModelWrapper.init();
        ClientRegistry.registerKeyBinding((KeyBinding)HELMET_INTERACT);
        ClientRegistry.registerKeyBinding((KeyBinding)LEGGINGS_INTERACT);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)TinkerTools.toolContainer.get()), ToolContainerScreen::new);
    }

    @SubscribeEvent
    static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)TinkerTools.hammerAttackParticle.get(), HammerAttackParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)TinkerTools.axeAttackParticle.get(), AxeAttackParticle.Factory::new);
    }

    @SubscribeEvent
    static void itemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        ToolModel.registerItemColors(colors, TinkerTools.pickaxe);
        ToolModel.registerItemColors(colors, TinkerTools.sledgeHammer);
        ToolModel.registerItemColors(colors, TinkerTools.veinHammer);
        ToolModel.registerItemColors(colors, TinkerTools.mattock);
        ToolModel.registerItemColors(colors, TinkerTools.excavator);
        ToolModel.registerItemColors(colors, TinkerTools.handAxe);
        ToolModel.registerItemColors(colors, TinkerTools.broadAxe);
        ToolModel.registerItemColors(colors, TinkerTools.kama);
        ToolModel.registerItemColors(colors, TinkerTools.scythe);
        ToolModel.registerItemColors(colors, TinkerTools.dagger);
        ToolModel.registerItemColors(colors, TinkerTools.sword);
        ToolModel.registerItemColors(colors, TinkerTools.cleaver);
    }

    private static void handleKeyBindings(TickEvent.PlayerTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71439_g != null && minecraft.field_71439_g == event.player && event.phase == TickEvent.Phase.START && event.side == LogicalSide.CLIENT && !minecraft.field_71439_g.func_175149_v()) {
            boolean isJumping = minecraft.field_71474_y.field_74314_A.func_151470_d();
            if (!wasJumping && isJumping && DoubleJumpModifier.extraJump(event.player)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.DOUBLE_JUMP);
            }
            wasJumping = isJumping;
            boolean isHelmetInteracting = HELMET_INTERACT.func_151470_d();
            if (!wasHelmetInteracting && isHelmetInteracting && InteractionHandler.startArmorInteract(event.player, EquipmentSlotType.HEAD)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.START_HELMET_INTERACT);
            }
            if (wasHelmetInteracting && !isHelmetInteracting && InteractionHandler.stopArmorInteract(event.player, EquipmentSlotType.HEAD)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.STOP_HELMET_INTERACT);
            }
            boolean isLeggingsInteract = LEGGINGS_INTERACT.func_151470_d();
            if (!wasLeggingsInteracting && isLeggingsInteract && InteractionHandler.startArmorInteract(event.player, EquipmentSlotType.LEGS)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.START_LEGGINGS_INTERACT);
            }
            if (wasLeggingsInteracting && !isLeggingsInteract && InteractionHandler.stopArmorInteract(event.player, EquipmentSlotType.LEGS)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.STOP_LEGGINGS_INTERACT);
            }
            wasHelmetInteracting = isHelmetInteracting;
            wasLeggingsInteracting = isLeggingsInteract;
        }
    }

    @Deprecated
    public static void registerMaterialItemColors(ItemColors colors, Supplier<? extends MaterialItem> item) {
    }

    @Deprecated
    public static void registerToolItemColors(ItemColors colors, Supplier<? extends IModifiable> item) {
        ToolModel.registerItemColors(colors, item);
    }
}

