/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.events.ToolEquipmentChangeEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.modifiers.impl.InventoryModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Orientation2D;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ability.armor.ShieldStrapModifier;
import slimeknights.tconstruct.tools.modifiers.upgrades.armor.ItemFrameModifier;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierClientEvents {
    private static final int SLOT_BACKGROUND_SIZE = 22;
    @Nonnull
    private static ItemStack nextOffhand = ItemStack.field_190927_a;
    private static final List<ItemStack> itemFrames = new ArrayList<ItemStack>();

    @SubscribeEvent
    static void onTooltipEvent(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() instanceof IModifiableDisplay) {
            event.getToolTip().removeIf(text -> {
                if (text instanceof TranslationTextComponent) {
                    return ((TranslationTextComponent)text).func_150268_i().equals("item.durability");
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    static void renderHand(RenderHandEvent event) {
        Hand hand = event.getHand();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (hand != Hand.OFF_HAND || player == null) {
            return;
        }
        ItemStack mainhand = player.func_184614_ca();
        ItemStack offhand = event.getItemStack();
        if (mainhand.func_77973_b().func_206844_a(TinkerTags.Items.TWO_HANDED)) {
            ToolStack tool = ToolStack.from(mainhand);
            IModDataReadOnly volatileData = tool.getVolatileData();
            boolean noInteraction = volatileData.getBoolean(IModifiable.NO_INTERACTION);
            if (!(noInteraction || volatileData.getBoolean(IModifiable.DEFER_OFFHAND) || offhand.func_77973_b() instanceof BlockItem && tool.getModifierLevel((Modifier)TinkerModifiers.exchanging.get()) != 0)) {
                event.setCanceled(true);
                return;
            }
            if (!noInteraction && offhand.func_190926_b()) {
                return;
            }
        }
        if (offhand.func_190926_b() && !player.func_82150_aj() && ModifierUtil.getTotalModifierLevel((LivingEntity)player, TinkerDataKeys.SHOW_EMPTY_OFFHAND) > 0) {
            MatrixStack matrices = event.getMatrixStack();
            matrices.func_227860_a_();
            Minecraft.func_71410_x().func_175597_ag().func_228401_a_(matrices, event.getBuffers(), event.getLight(), event.getEquipProgress(), event.getSwingProgress(), player.func_184591_cq().func_188468_a());
            matrices.func_227865_b_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void handleZoom(FOVUpdateEvent event) {
        event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            FloatMultiplier zoom = data.get(TinkerDataKeys.FOV_MODIFIER);
            if (zoom != null) {
                event.setNewfov(event.getNewfov() * zoom.getValue());
            }
        });
    }

    @SubscribeEvent
    static void equipmentChange(ToolEquipmentChangeEvent event) {
        InventoryModifier modifier;
        int level;
        IModifierToolStack tool;
        EquipmentChangeContext context = event.getContext();
        if (((Boolean)Config.CLIENT.renderShieldSlotItem.get()).booleanValue() && event.getEntityLiving() == Minecraft.func_71410_x().field_71439_g && context.getChangedSlot() == EquipmentSlotType.LEGS) {
            tool = context.getToolInSlot(EquipmentSlotType.LEGS);
            if (tool != null && (level = tool.getModifierLevel(modifier = (ShieldStrapModifier)TinkerModifiers.shieldStrap.get())) > 0) {
                nextOffhand = modifier.getStack(tool, level, 0);
                return;
            }
            nextOffhand = ItemStack.field_190927_a;
        }
        if (((Boolean)Config.CLIENT.renderItemFrame.get()).booleanValue() && event.getEntityLiving() == Minecraft.func_71410_x().field_71439_g && context.getChangedSlot() == EquipmentSlotType.HEAD) {
            itemFrames.clear();
            tool = context.getToolInSlot(EquipmentSlotType.HEAD);
            if (tool != null && (level = tool.getModifierLevel(modifier = (ItemFrameModifier)TinkerModifiers.itemFrame.get())) > 0) {
                ((ItemFrameModifier)modifier).getAllStacks(tool, level, itemFrames);
            }
        }
    }

    @SubscribeEvent
    static void renderHotbar(RenderGameOverlayEvent.Post event) {
        boolean renderItemFrame;
        boolean renderShield = (Boolean)Config.CLIENT.renderShieldSlotItem.get() != false && !nextOffhand.func_190926_b();
        boolean bl = renderItemFrame = (Boolean)Config.CLIENT.renderItemFrame.get() != false && !itemFrames.isEmpty();
        if (!renderItemFrame && !renderShield) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            ClientPlayerEntity player;
            Minecraft mc = Minecraft.func_71410_x();
            PlayerController playerController = Minecraft.func_71410_x().field_71442_b;
            if (playerController != null && playerController.func_178889_l() != GameType.SPECTATOR && (player = Minecraft.func_71410_x().field_71439_g) != null && player == mc.func_175606_aa()) {
                RenderSystem.enableRescaleNormal();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                int scaledWidth = mc.func_228018_at_().func_198107_o();
                int scaledHeight = mc.func_228018_at_().func_198087_p();
                MatrixStack matrixStack = event.getMatrixStack();
                float partialTicks = event.getPartialTicks();
                if (renderShield) {
                    mc.func_110434_K().func_110577_a(Icons.ICONS);
                    int x = scaledWidth / 2 + (player.func_184591_cq().func_188468_a() == HandSide.LEFT ? -117 : 101);
                    int y = scaledHeight - 38;
                    Screen.func_238463_a_((MatrixStack)matrixStack, (int)(x - 3), (int)(y - 3), (float)(player.func_184592_cb().func_190926_b() ? 211.0f : 189.0f), (float)0.0f, (int)22, (int)22, (int)256, (int)256);
                    mc.field_71456_v.func_184044_a(x, y, partialTicks, (PlayerEntity)player, nextOffhand);
                }
                if (renderItemFrame) {
                    int c;
                    int columns = (Integer)Config.CLIENT.itemsPerRow.get();
                    int count = itemFrames.size();
                    int rows = count / columns;
                    int inLastRow = count % columns;
                    if (inLastRow == 0) {
                        inLastRow = columns;
                    } else {
                        ++rows;
                    }
                    Orientation2D location = (Orientation2D)((Object)Config.CLIENT.itemFrameLocation.get());
                    Orientation2D.Orientation1D xOrientation = location.getX();
                    Orientation2D.Orientation1D yOrientation = location.getY();
                    int xStart = xOrientation.align(scaledWidth - 22 * columns) + (Integer)Config.CLIENT.itemFrameXOffset.get();
                    int yStart = yOrientation.align(scaledHeight - 22 * rows) + (Integer)Config.CLIENT.itemFrameYOffset.get();
                    mc.func_110434_K().func_110577_a(Icons.ICONS);
                    int lastRow = rows - 1;
                    for (int r = 0; r < lastRow; ++r) {
                        for (c = 0; c < columns; ++c) {
                            Screen.func_238463_a_((MatrixStack)matrixStack, (int)(xStart + c * 22), (int)(yStart + r * 22), (float)167.0f, (float)0.0f, (int)22, (int)22, (int)256, (int)256);
                        }
                    }
                    int lastRowOffset = xOrientation.align((columns - inLastRow) * 2) * 22 / 2;
                    for (c = 0; c < inLastRow; ++c) {
                        Screen.func_238463_a_((MatrixStack)matrixStack, (int)(xStart + c * 22 + lastRowOffset), (int)(yStart + lastRow * 22), (float)167.0f, (float)0.0f, (int)22, (int)22, (int)256, (int)256);
                    }
                    int i = 0;
                    xStart += 3;
                    yStart += 3;
                    for (int r = 0; r < lastRow; ++r) {
                        for (int c2 = 0; c2 < columns; ++c2) {
                            mc.field_71456_v.func_184044_a(xStart + c2 * 22, yStart + r * 22, partialTicks, (PlayerEntity)player, itemFrames.get(i));
                            ++i;
                        }
                    }
                    for (int c3 = 0; c3 < inLastRow; ++c3) {
                        mc.field_71456_v.func_184044_a(xStart + c3 * 22 + lastRowOffset, yStart + lastRow * 22, partialTicks, (PlayerEntity)player, itemFrames.get(i));
                        ++i;
                    }
                }
                RenderSystem.disableRescaleNormal();
                RenderSystem.disableBlend();
            }
        }
    }
}

