/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.layout.Patterns;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.inventory.ToolContainer;

public class ToolContainerScreen
extends ContainerScreen<ToolContainer> {
    private static final ResourceLocation TEXTURE = TConstruct.getResource("textures/gui/tool.png");
    private static final int REPEAT_BACKGROUND_ROWS = 6;
    private static final int PLAYER_INVENTORY_START = 125;
    private static final int PLAYER_INVENTORY_HEIGHT = 97;
    private static final int SLOTS_START = 238;
    private static final int SELECTED_X = 176;
    private final int slots;
    private final int inventoryRows;
    private final int slotsInLastRow;
    private final IModifierToolStack tool;

    public ToolContainerScreen(ToolContainer container, PlayerInventory inv, ITextComponent title) {
        super((Container)container, inv, title);
        int slots = container.getItemHandler().getSlots();
        if (container.isShowOffhand()) {
            ++slots;
        }
        int inventoryRows = slots / 9;
        int slotsInLastRow = slots % 9;
        if (slotsInLastRow == 0) {
            slotsInLastRow = 9;
        } else {
            ++inventoryRows;
        }
        this.slots = slots;
        this.inventoryRows = inventoryRows;
        this.slotsInLastRow = slotsInLastRow;
        this.field_147000_g = 114 + this.inventoryRows * 18;
        this.field_238745_s_ = this.field_147000_g - 94;
        this.tool = ToolStack.from(container.getStack());
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        Slot slot;
        int yOffset;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        if (this.inventoryRows <= 6) {
            yOffset = this.inventoryRows * 18 + 17;
            this.func_238474_b_(matrixStack, xStart, yStart, 0, 0, this.field_146999_f, yOffset);
        } else {
            int remaining;
            yOffset = 125;
            this.func_238474_b_(matrixStack, xStart, yStart, 0, 0, this.field_146999_f, yOffset);
            int height = 108;
            for (remaining = this.inventoryRows - 6; remaining > 6; remaining -= 6) {
                this.func_238474_b_(matrixStack, xStart, yStart + yOffset, 0, 17, this.field_146999_f, height);
                yOffset += height;
            }
            height = remaining * 18;
            this.func_238474_b_(matrixStack, xStart, yStart + yOffset, 0, 17, this.field_146999_f, height);
            yOffset += height;
        }
        this.func_238474_b_(matrixStack, xStart, yStart + yOffset, 0, 125, this.field_146999_f, 97);
        int rowLeft = xStart + 7;
        int rowStart = yStart + 17 - 18;
        for (int i = 1; i < this.inventoryRows; ++i) {
            this.func_238474_b_(matrixStack, rowLeft, rowStart + i * 18, 0, 238, 162, 18);
        }
        this.func_238474_b_(matrixStack, rowLeft, rowStart + this.inventoryRows * 18, 0, 238, this.slotsInLastRow * 18, 18);
        int selectedSlot = ((ToolContainer)this.field_147002_h).getSelectedHotbarSlot();
        if (selectedSlot != -1) {
            int slotIndex = this.slots - 1;
            if (selectedSlot != 10) {
                slotIndex += 28 + selectedSlot;
            }
            if (slotIndex < ((ToolContainer)this.field_147002_h).field_75151_b.size()) {
                Slot slot2 = ((ToolContainer)this.field_147002_h).func_75139_a(slotIndex);
                this.func_238474_b_(matrixStack, xStart + slot2.field_75223_e - 2, yStart + slot2.field_75221_f - 2, 176, 0, 20, 20);
            }
        }
        this.field_230706_i_.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        Function spriteGetter = this.field_230706_i_.func_228015_a_(PlayerContainer.field_226615_c_);
        int start = 0;
        int maxSlots = ((ToolContainer)this.field_147002_h).field_75151_b.size();
        block2: for (ModifierEntry entry : this.tool.getModifierList()) {
            ToolInventoryCapability.IInventoryModifier inventory = entry.getModifier().getModule(ToolInventoryCapability.IInventoryModifier.class);
            if (inventory == null) continue;
            int level = entry.getLevel();
            int size = inventory.getSlots(this.tool, level);
            for (int i = 0; i < size; ++i) {
                if (start + i >= maxSlots) break block2;
                Slot slot3 = ((ToolContainer)this.field_147002_h).func_75139_a(start + i);
                Pattern pattern = inventory.getPattern(this.tool, level, i, slot3.func_75216_d());
                if (pattern == null) continue;
                TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(pattern.getTexture());
                ToolContainerScreen.func_238470_a_((MatrixStack)matrixStack, (int)(xStart + slot3.field_75223_e), (int)(yStart + slot3.field_75221_f), (int)100, (int)16, (int)16, (TextureAtlasSprite)sprite);
            }
            start += size;
        }
        if (((ToolContainer)this.field_147002_h).isShowOffhand() && !(slot = ((ToolContainer)this.field_147002_h).func_75139_a(this.slots - 1)).func_75216_d()) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(Patterns.SHIELD.getTexture());
            ToolContainerScreen.func_238470_a_((MatrixStack)matrixStack, (int)(xStart + slot.field_75223_e), (int)(yStart + slot.field_75221_f), (int)100, (int)16, (int)16, (TextureAtlasSprite)sprite);
        }
    }
}

