/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.item.IModifiableHarvest;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ToolRenderEvents {
    private static final int MAX_BLOCKS = 60;

    @SubscribeEvent
    static void renderBlockHighlights(DrawHighlightEvent.HighlightBlock event) {
        BlockState state;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (world == null || player == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || !TinkerTags.Items.HARVEST_PRIMARY.func_230235_a_((Object)stack.func_77973_b())) {
            return;
        }
        RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
        if (result == null || result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken() || !(stack.func_77973_b() instanceof IModifiableHarvest)) {
            return;
        }
        BlockRayTraceResult blockTrace = event.getTarget();
        BlockPos origin = blockTrace.func_216350_a();
        ToolHarvestLogic harvestLogic = ((IModifiableHarvest)stack.func_77973_b()).getToolHarvestLogic();
        if (!harvestLogic.isEffective(tool, stack, state = world.func_180495_p(origin))) {
            return;
        }
        Iterator<BlockPos> extraBlocks = harvestLogic.getAOEBlocks(tool, stack, (PlayerEntity)player, world.func_180495_p(origin), (World)world, origin, blockTrace.func_216354_b(), ToolHarvestLogic.AOEMatchType.BREAKING).iterator();
        if (!extraBlocks.hasNext()) {
            return;
        }
        WorldRenderer worldRender = event.getContext();
        MatrixStack matrices = event.getMatrix();
        IRenderTypeBuffer.Impl buffers = worldRender.field_228415_m_.func_228487_b_();
        IVertexBuilder vertexBuilder = buffers.getBuffer(RenderType.func_228659_m_());
        matrices.func_227860_a_();
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Entity viewEntity = renderInfo.func_216773_g();
        Vector3d vector3d = renderInfo.func_216785_c();
        double x = vector3d.func_82615_a();
        double y = vector3d.func_82617_b();
        double z = vector3d.func_82616_c();
        int rendered = 0;
        do {
            BlockPos pos = extraBlocks.next();
            if (!world.func_175723_af().func_177746_a(pos)) continue;
            ++rendered;
            worldRender.func_228429_a_(matrices, vertexBuilder, viewEntity, x, y, z, pos, world.func_180495_p(pos));
        } while (rendered < 60 && extraBlocks.hasNext());
        matrices.func_227865_b_();
        buffers.func_228461_a_();
    }

    @SubscribeEvent
    static void renderBlockDamageProgress(RenderWorldLastEvent event) {
        BlockState state;
        PlayerController controller = Minecraft.func_71410_x().field_71442_b;
        if (controller == null || !controller.func_181040_m()) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (world == null || player == null || Minecraft.func_71410_x().func_175606_aa() == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || !TinkerTags.Items.HARVEST_PRIMARY.func_230235_a_((Object)stack.func_77973_b())) {
            return;
        }
        RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
        if (result == null || result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken() || !(stack.func_77973_b() instanceof IModifiableHarvest)) {
            return;
        }
        BlockRayTraceResult blockTrace = (BlockRayTraceResult)result;
        BlockPos target = blockTrace.func_216350_a();
        DestroyBlockProgress progress = null;
        for (Int2ObjectMap.Entry entry : Minecraft.func_71410_x().field_71438_f.field_72738_E.int2ObjectEntrySet()) {
            if (!((DestroyBlockProgress)entry.getValue()).func_180246_b().equals((Object)target)) continue;
            progress = (DestroyBlockProgress)entry.getValue();
            break;
        }
        if (progress == null) {
            return;
        }
        ToolHarvestLogic harvestLogic = ((IModifiableHarvest)stack.func_77973_b()).getToolHarvestLogic();
        if (!harvestLogic.isEffective(tool, stack, state = world.func_180495_p(target))) {
            return;
        }
        Iterator<BlockPos> extraBlocks = harvestLogic.getAOEBlocks(tool, stack, (PlayerEntity)player, state, (World)world, target, blockTrace.func_216354_b(), ToolHarvestLogic.AOEMatchType.BREAKING).iterator();
        if (!extraBlocks.hasNext()) {
            return;
        }
        MatrixStack matrices = event.getMatrixStack();
        matrices.func_227860_a_();
        IRenderTypeBuffer.Impl vertices = event.getContext().field_228415_m_.func_228489_c_();
        IVertexBuilder vertexBuilder = vertices.getBuffer((RenderType)ModelBakery.field_229320_k_.get(progress.func_73106_e()));
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        double x = renderInfo.func_216785_c().field_72450_a;
        double y = renderInfo.func_216785_c().field_72448_b;
        double z = renderInfo.func_216785_c().field_72449_c;
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        int rendered = 0;
        do {
            BlockPos pos = extraBlocks.next();
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)pos.func_177958_n() - x, (double)pos.func_177956_o() - y, (double)pos.func_177952_p() - z);
            MatrixStack.Entry entry = matrices.func_227866_c_();
            MatrixApplyingVertexBuilder blockBuilder = new MatrixApplyingVertexBuilder(vertexBuilder, entry.func_227870_a_(), entry.func_227872_b_());
            dispatcher.func_228792_a_(world.func_180495_p(pos), pos, (IBlockDisplayReader)world, matrices, (IVertexBuilder)blockBuilder);
            matrices.func_227865_b_();
        } while (++rendered < 60 && extraBlocks.hasNext());
        matrices.func_227865_b_();
        vertices.func_228461_a_();
    }
}

