/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableWeapon;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class InteractionHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    static void beforeEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        EquipmentSlotType slotType = Util.getSlotType(hand);
        if (!TinkerTags.Items.HELD.func_230235_a_((Object)stack.func_77973_b())) {
            if (!stack.func_190926_b()) return;
            stack = player.func_184582_a(EquipmentSlotType.CHEST);
            if (!TinkerTags.Items.CHESTPLATES.func_230235_a_((Object)stack.func_77973_b())) return;
            slotType = EquipmentSlotType.CHEST;
        }
        ToolStack tool = ToolStack.from(stack);
        Entity target = event.getTarget();
        for (ModifierEntry entry : tool.getModifierList()) {
            ActionResultType result = entry.getModifier().beforeEntityUse(tool, entry.getLevel(), player, target, hand, slotType);
            if (!result.func_226246_a_()) continue;
            event.setCanceled(true);
            event.setCancellationResult(result);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void afterEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack chestplate;
        PlayerEntity player = event.getPlayer();
        if (event.getItemStack().func_190926_b() && !player.func_175149_v() && TinkerTags.Items.CHESTPLATES.func_230235_a_((Object)(chestplate = player.func_184582_a(EquipmentSlotType.CHEST)).func_77973_b())) {
            event.setCanceled(true);
            ToolStack tool = ToolStack.from(chestplate);
            Entity target = event.getTarget();
            Hand hand = event.getHand();
            ActionResultType result = target.func_184230_a(player, hand);
            if (result.func_226246_a_()) {
                event.setCancellationResult(result);
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                for (ModifierEntry entry : tool.getModifierList()) {
                    result = entry.getModifier().afterEntityUse(tool, entry.getLevel(), player, livingTarget, hand, EquipmentSlotType.CHEST);
                    if (!result.func_226246_a_()) continue;
                    event.setCanceled(true);
                    event.setCancellationResult(result);
                    return;
                }
            }
            result = InteractionHandler.onChestplateUse(player, chestplate, hand);
            event.setCancellationResult(result);
        }
    }

    private static ActionResultType onBlockUse(ItemUseContext context, IModifierToolStack tool, ItemStack stack, Function<ModifierEntry, ActionResultType> callback) {
        PlayerEntity player = context.func_195999_j();
        CachedBlockInfo cachedblockinfo = new CachedBlockInfo((IWorldReader)context.func_195991_k(), context.func_195995_a(), false);
        if (player != null && !player.field_71075_bZ.field_75099_e && !stack.func_206847_b(context.func_195991_k().func_205772_D(), cachedblockinfo)) {
            return ActionResultType.PASS;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            ActionResultType result = callback.apply(entry);
            if (!result.func_226246_a_()) continue;
            if (player != null) {
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
            }
            return result;
        }
        return ActionResultType.PASS;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void chestplateInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack chestplate;
        PlayerEntity player = event.getPlayer();
        if (event.getItemStack().func_190926_b() && !player.func_175149_v() && TinkerTags.Items.CHESTPLATES.func_230235_a_((Object)(chestplate = player.func_184582_a(EquipmentSlotType.CHEST)).func_77973_b())) {
            ActionResultType result;
            ActionResultType result2;
            ActionResultType result3;
            ToolStack tool = ToolStack.from(chestplate);
            Hand hand = event.getHand();
            BlockRayTraceResult trace = event.getHitVec();
            ItemUseContext context = new ItemUseContext(player, hand, trace);
            if (event.getUseItem() != Event.Result.DENY && (result3 = InteractionHandler.onBlockUse(context, tool, chestplate, entry -> entry.getModifier().beforeBlockUse(tool, entry.getLevel(), context, EquipmentSlotType.CHEST))).func_226246_a_()) {
                event.setCanceled(true);
                event.setCancellationResult(result3);
                return;
            }
            BlockPos pos = event.getPos();
            Event.Result useBlock = event.getUseBlock();
            World world = player.func_130014_f_();
            if ((useBlock == Event.Result.ALLOW || useBlock != Event.Result.DENY && (!player.func_226563_dT_() || player.func_184586_b(Util.getOpposite(hand)).doesSneakBypassUse((IWorldReader)world, pos, player))) && (result2 = world.func_180495_p(pos).func_227031_a_(world, player, hand, trace)).func_226246_a_()) {
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_232607_M_.func_226695_a_((ServerPlayerEntity)player, pos, ItemStack.field_190927_a);
                }
                event.setCanceled(true);
                event.setCancellationResult(result2);
                return;
            }
            Event.Result useItem = event.getUseItem();
            event.setCancellationResult(ActionResultType.PASS);
            if (useItem != Event.Result.DENY && (useItem == Event.Result.ALLOW || !player.func_184811_cZ().func_185141_a(chestplate.func_77973_b())) && (result = InteractionHandler.onBlockUse(context, tool, chestplate, entry -> entry.getModifier().afterBlockUse(tool, entry.getLevel(), context, EquipmentSlotType.CHEST))).func_226246_a_()) {
                event.setCanceled(true);
                event.setCancellationResult(result);
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_232607_M_.func_226695_a_((ServerPlayerEntity)player, pos, ItemStack.field_190927_a);
                }
                return;
            }
            result = InteractionHandler.onChestplateUse(player, chestplate, hand);
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public static ActionResultType onChestplateUse(PlayerEntity player, ItemStack chestplate, Hand hand) {
        if (player.func_184811_cZ().func_185141_a(chestplate.func_77973_b())) {
            return ActionResultType.PASS;
        }
        ToolStack tool = ToolStack.from(chestplate);
        World world = player.func_130014_f_();
        for (ModifierEntry entry : tool.getModifierList()) {
            ActionResultType result = entry.getModifier().onToolUse(tool, entry.getLevel(), world, player, hand, EquipmentSlotType.CHEST);
            if (!result.func_226246_a_()) continue;
            return result;
        }
        return ActionResultType.PASS;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void onChestplateAttack(AttackEntityEvent event) {
        ToolStack tool;
        ItemStack chestplate;
        PlayerEntity attacker = event.getPlayer();
        if (attacker.func_184614_ca().func_190926_b() && TinkerTags.Items.CHESTPLATES.func_230235_a_((Object)(chestplate = attacker.func_184582_a(EquipmentSlotType.CHEST)).func_77973_b()) && !(tool = ToolStack.from(chestplate)).isBroken() && tool.getModifierLevel((Modifier)TinkerModifiers.unarmed.get()) > 0) {
            ToolAttackUtil.attackEntity(IModifiableWeapon.DEFAULT, tool, (LivingEntity)attacker, Hand.MAIN_HAND, event.getTarget(), ToolAttackUtil.getCooldownFunction(attacker, Hand.MAIN_HAND), false, EquipmentSlotType.CHEST);
            event.setCanceled(true);
        }
    }

    public static boolean startArmorInteract(PlayerEntity player, EquipmentSlotType slotType) {
        ItemStack helmet;
        if (!player.func_175149_v() && TinkerTags.Items.ARMOR.func_230235_a_((Object)(helmet = player.func_184582_a(slotType)).func_77973_b())) {
            ModifierEntry entry;
            IArmorInteractModifier helmetInteract;
            ToolStack tool = ToolStack.from(helmet);
            Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && ((helmetInteract = (entry = iterator.next()).getModifier().getModule(IArmorInteractModifier.class)) == null || !helmetInteract.startArmorInteract(tool, entry.getLevel(), player, slotType))) {
            }
            return true;
        }
        return false;
    }

    public static boolean stopArmorInteract(PlayerEntity player, EquipmentSlotType slotType) {
        ItemStack helmet;
        if (!player.func_175149_v() && TinkerTags.Items.ARMOR.func_230235_a_((Object)(helmet = player.func_184582_a(slotType)).func_77973_b())) {
            ToolStack tool = ToolStack.from(helmet);
            for (ModifierEntry entry : tool.getModifierList()) {
                IArmorInteractModifier helmetInteract = entry.getModifier().getModule(IArmorInteractModifier.class);
                if (helmetInteract == null) continue;
                helmetInteract.stopArmorInteract(tool, entry.getLevel(), player, slotType);
            }
            return true;
        }
        return false;
    }
}

