/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.logic.ModifierMaxLevel;

public abstract class AbstractProtectionModifier<T extends ModifierMaxLevel>
extends IncrementalModifier {
    private final TinkerDataCapability.TinkerDataKey<T> key;

    public AbstractProtectionModifier(int color, TinkerDataCapability.TinkerDataKey<T> key) {
        super(color);
        this.key = key;
    }

    protected abstract T createData();

    protected void reset(T data) {
    }

    @Override
    public void onUnequip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlotType slot = context.getChangedSlot();
        if (slot.func_188453_a() == EquipmentSlotType.Group.ARMOR && !entity.func_130014_f_().field_72995_K) {
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel modData = (ModifierMaxLevel)data.get(this.key);
                if (modData != null) {
                    modData.set(slot, 0.0f);
                    if (modData.getMax() == 0.0f) {
                        this.reset(modData);
                    }
                }
            });
        }
    }

    @Override
    public void onEquip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlotType slot = context.getChangedSlot();
        if (!entity.func_130014_f_().field_72995_K && slot.func_188453_a() == EquipmentSlotType.Group.ARMOR && !tool.isBroken()) {
            float scaledLevel = this.getScaledLevel(tool, level);
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel modData = (ModifierMaxLevel)data.get(this.key);
                if (modData == null) {
                    modData = this.createData();
                    data.put(this.key, modData);
                }
                modData.set(slot, scaledLevel);
            });
        }
    }
}

