/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.tools.logic.ModifierMaxLevel;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;
import slimeknights.tconstruct.tools.modifiers.defense.ProtectionModifier;

public class ProjectileProtectionModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final TinkerDataCapability.TinkerDataKey<ModifierMaxLevel> PROJECTILE_DATA = TConstruct.createKey("projectile_protection");

    public ProjectileProtectionModifier() {
        super(14854230, PROJECTILE_DATA);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingEvent.LivingVisibilityEvent.class, ProjectileProtectionModifier::livingVisibility);
    }

    @Override
    protected ModifierMaxLevel createData() {
        return new ModifierMaxLevel();
    }

    @Override
    public float getProtectionModifier(IModifierToolStack tool, int level, EquipmentContext context, EquipmentSlotType slotType, DamageSource source, float modifierValue) {
        if (!source.func_151517_h() && !source.func_76357_e() && source.func_76352_a()) {
            modifierValue += this.getScaledLevel(tool, level) * 2.0f;
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, TooltipFlag tooltipFlag) {
        ProtectionModifier.addResistanceTooltip(this, tool, level, 2.0f, tooltip);
    }

    private static void livingVisibility(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity living = event.getEntityLiving();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            float max;
            ModifierMaxLevel projData = data.get(PROJECTILE_DATA);
            if (projData != null && (max = projData.getMax()) > 0.0f) {
                event.modifyVisibility(Math.max(0.0, 1.0 - (double)max * 0.05));
            }
        });
    }
}

