/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public class ConductingModifier
extends Modifier {
    private static final ITextComponent ATTACK_DAMAGE = TConstruct.makeTranslation("modifier", "conducting.attack_damage");
    private static final int MAX_BONUS_TICKS = 300;
    private static final float PERCENT_PER_LEVEL = 0.15f;

    public ConductingModifier() {
        super(14404619);
    }

    @Override
    public int getPriority() {
        return 90;
    }

    private static float getBonus(LivingEntity living, int level) {
        int fire = living.func_223314_ad();
        if (fire > 0) {
            float bonus = 0.15f * (float)level;
            if (fire < 300) {
                bonus *= (float)fire / 300.0f;
            }
            if (living.func_70644_a(Effects.field_76426_n)) {
                bonus /= 2.0f;
            }
            return bonus;
        }
        return 0.0f;
    }

    @Override
    public float getEntityDamage(IModifierToolStack tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        float bonus = ConductingModifier.getBonus(context.getAttacker(), level);
        if (bonus > 0.0f) {
            damage *= 1.0f + bonus;
        }
        return damage;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey key, TooltipFlag flag) {
        if (tool.hasTag((ITag<Item>)TinkerTags.Items.MELEE_OR_UNARMED)) {
            float bonus = 0.15f * (float)level;
            if (player != null && key == TooltipKey.SHIFT && player.func_223314_ad() == 0) {
                bonus = 0.0f;
            }
            tooltip.add((ITextComponent)this.applyStyle(new StringTextComponent(Util.PERCENT_BOOST_FORMAT.format(bonus)).func_240702_b_(" ").func_230529_a_(ATTACK_DAMAGE)));
        }
    }
}

