/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.TankModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SearingModifier
extends Modifier {
    private static final float BASELINE_TEMPERATURE = 0.75f;

    public SearingModifier() {
        super(5196359);
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        ((TankModifier)TinkerModifiers.tank.get()).addCapacity(volatileData, 288);
    }

    private static float temperatureBoost(LivingEntity living, int level) {
        BlockPos attackerPos = living.func_233580_cy_();
        return (living.field_70170_p.func_226691_t_(attackerPos).func_225486_c(attackerPos) - 0.75f) * (float)(level * 2);
    }

    @Override
    public float getEntityDamage(IModifierToolStack tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        return damage + SearingModifier.temperatureBoost(context.getAttacker(), level) * tool.getModifier(ToolStats.ATTACK_DAMAGE);
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey key, TooltipFlag flag) {
        float bonus = player != null && key == TooltipKey.SHIFT ? SearingModifier.temperatureBoost((LivingEntity)player, level) : (float)level * 2.5f;
        this.addDamageTooltip(tool, bonus, tooltip);
    }
}

