/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.LightType;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorWalkModifier;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class LightspeedArmorModifier
extends IncrementalModifier
implements IArmorWalkModifier {
    private static final UUID ATTRIBUTE_BONUS = UUID.fromString("8790747b-6654-4bd8-83c7-dbe9ae04c0ca");

    public LightspeedArmorModifier() {
        super(16759902);
    }

    @Override
    public void onWalk(IModifierToolStack tool, int level, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (tool.isBroken() || !living.func_233570_aj_() || living.field_70170_p.field_72995_K) {
            return;
        }
        ModifiableAttributeInstance attribute = living.func_110148_a(Attributes.field_233821_d_);
        if (attribute == null) {
            return;
        }
        if (attribute.func_111127_a(ATTRIBUTE_BONUS) != null) {
            attribute.func_188479_b(ATTRIBUTE_BONUS);
        }
        Vector3d vecPos = living.func_213303_ch();
        BlockPos pos = new BlockPos(vecPos.field_72450_a, vecPos.field_72448_b + 0.5, vecPos.field_72449_c);
        int light = living.field_70170_p.func_226658_a_(LightType.BLOCK, pos);
        if (light > 5) {
            int scaledLight = light - 5;
            attribute.func_233767_b_(new AttributeModifier(ATTRIBUTE_BONUS, "tconstruct.modifier.lightspeed", (double)((float)scaledLight * 0.0015f * this.getScaledLevel(tool, level)), AttributeModifier.Operation.ADDITION));
            if (RANDOM.nextFloat() < 0.005f * (float)scaledLight) {
                ToolDamageUtil.damageAnimated(tool, 1, living, EquipmentSlotType.FEET);
            }
        }
    }

    @Override
    public void onUnequip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        ModifiableAttributeInstance attribute;
        IModifierToolStack newTool;
        LivingEntity livingEntity = context.getEntity();
        if (context.getChangedSlot() == EquipmentSlotType.FEET && ((newTool = context.getReplacementTool()) == null || newTool.isBroken() || this.getScaledLevel(newTool, newTool.getModifierLevel(this)) != this.getScaledLevel(tool, level)) && (attribute = livingEntity.func_110148_a(Attributes.field_233821_d_)) != null && attribute.func_111127_a(ATTRIBUTE_BONUS) != null) {
            attribute.func_188479_b(ATTRIBUTE_BONUS);
        }
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        return LightspeedArmorModifier.tryModuleMatch(type, IArmorWalkModifier.class, this);
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        float boost;
        if (player != null && key == TooltipKey.SHIFT) {
            int light = player.field_70170_p.func_226658_a_(LightType.BLOCK, player.func_233580_cy_());
            boost = 0.015f * (float)(light - 5) * this.getScaledLevel(tool, level);
        } else {
            boost = 0.15f * this.getScaledLevel(tool, level);
        }
        if (boost > 0.0f) {
            this.addPercentTooltip(this.getDisplayName(), boost, tooltip);
        }
    }
}

