/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.tile;

import codechicken.chunkloader.api.ChunkLoaderShape;
import codechicken.chunkloader.api.IChunkLoaderHandler;
import codechicken.chunkloader.handler.ChickenChunksConfig;
import codechicken.chunkloader.init.ModContent;
import codechicken.chunkloader.network.ChunkLoaderSPH;
import codechicken.chunkloader.tile.TileChunkLoaderBase;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;

public class TileChunkLoader
extends TileChunkLoaderBase {
    public int radius;
    public ChunkLoaderShape shape = ChunkLoaderShape.SQUARE;

    public TileChunkLoader() {
        super(ModContent.tileChunkLoaderType);
    }

    public boolean setShapeAndRadius(ChunkLoaderShape newShape, int newRadius) {
        return this.setShapeAndRadius(null, newShape, newRadius);
    }

    public boolean setShapeAndRadius(ServerPlayerEntity player, ChunkLoaderShape newShape, int newRadius) {
        if (this.owner == null || newRadius < 0 || newRadius > 255) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            this.radius = newRadius;
            this.shape = newShape;
            return true;
        }
        Set<ChunkPos> chunks = TileChunkLoader.getContainedChunks(newShape, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177952_p(), newRadius);
        ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(this.owner);
        if (chunks.size() > restrictions.getChunksPerLoader()) {
            if (player != null) {
                int more = chunks.size() - restrictions.getChunksPerLoader();
                ChunkLoaderSPH.sendGuiWarning(player, (ITextComponent)new TranslationTextComponent("chickenchunks.gui.morechunks", new Object[]{more}));
            }
            return false;
        }
        if (this.powered) {
            this.radius = newRadius;
            this.shape = newShape;
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
            ChunkLoaderSPH.sendStateUpdate(this);
            return true;
        }
        IChunkLoaderHandler handler = IChunkLoaderHandler.getCapability((IWorld)this.field_145850_b);
        if (handler.canLoadChunks(this, chunks)) {
            this.radius = newRadius;
            this.shape = newShape;
            handler.updateLoader(this);
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
            ChunkLoaderSPH.sendStateUpdate(this);
            return true;
        }
        return false;
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeEnum((Enum)this.shape);
        packet.writeByte(this.radius);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.setShapeAndRadius((ChunkLoaderShape)packet.readEnum(ChunkLoaderShape.class), packet.readUByte());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("radius", (byte)this.radius);
        tag.func_74774_a("shape", (byte)this.shape.ordinal());
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.radius = tag.func_74771_c("radius");
        this.shape = ChunkLoaderShape.values()[tag.func_74771_c("shape")];
    }

    @Override
    public Set<ChunkPos> getChunks() {
        return TileChunkLoader.getContainedChunks(this.shape, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177952_p(), this.radius);
    }

    public static Set<ChunkPos> getContainedChunks(ChunkLoaderShape shape, int xCoord, int zCoord, int radius) {
        return shape.getLoadedChunks(xCoord >> 4, zCoord >> 4, radius - 1);
    }

    public int countLoadedChunks() {
        return this.getChunks().size();
    }

    @Override
    public void activate() {
        if (this.owner == null) {
            return;
        }
        if (this.radius == 0) {
            this.radius = 1;
            this.shape = ChunkLoaderShape.SQUARE;
            this.setShapeAndRadius(ChunkLoaderShape.SQUARE, 2);
        }
        super.activate();
    }
}

