/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.world;

import codechicken.chunkloader.api.IChunkLoader;
import codechicken.chunkloader.api.IChunkLoaderHandler;
import codechicken.chunkloader.handler.ChickenChunksConfig;
import codechicken.chunkloader.world.ChunkTicket;
import codechicken.chunkloader.world.Organiser;
import codechicken.lib.capability.SimpleCapProviderSerializable;
import codechicken.lib.util.SneakyUtils;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkLoaderHandler
implements IChunkLoaderHandler {
    private static final Logger logger = LogManager.getLogger();
    private static final ResourceLocation KEY = new ResourceLocation("chickenchunks", "chunk_loaders");
    private static final boolean DEBUG = Boolean.getBoolean("chickenchunks.loading.debug");
    @CapabilityInject(value=IChunkLoaderHandler.class)
    public static final Capability<IChunkLoaderHandler> HANDLER_CAPABILITY = null;
    private final MinecraftServer server;
    private final Table<UUID, ResourceLocation, Organiser> playerOrganisers = HashBasedTable.create();
    private final Table<ResourceLocation, ChunkPos, ChunkTicket> activeTickets = HashBasedTable.create();
    private final List<Organiser> deviveList = new LinkedList<Organiser>();
    private final List<Organiser> reviveList = new LinkedList<Organiser>();
    private final Object2LongMap<UUID> loginTimes = new Object2LongOpenHashMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ChunkLoaderHandler::onPlayerLogin);
        MinecraftForge.EVENT_BUS.addListener(ChunkLoaderHandler::onPlayerLoggedOut);
        MinecraftForge.EVENT_BUS.addListener(ChunkLoaderHandler::onWorldLoad);
        MinecraftForge.EVENT_BUS.addListener(ChunkLoaderHandler::onWorldTick);
        MinecraftForge.EVENT_BUS.addGenericListener(World.class, ChunkLoaderHandler::attachCapabilities);
        CapabilityManager.INSTANCE.register(IChunkLoaderHandler.class, (Capability.IStorage)new Storage(), SneakyUtils.nullC());
        ForgeChunkManager.setForcedChunkLoadingCallback((String)"chickenchunks", (world, ticketHelper) -> {
            ticketHelper.getBlockTickets().keySet().forEach(arg_0 -> ((ForgeChunkManager.TicketHelper)ticketHelper).removeAllTickets(arg_0));
            ticketHelper.getEntityTickets().keySet().forEach(arg_0 -> ((ForgeChunkManager.TicketHelper)ticketHelper).removeAllTickets(arg_0));
        });
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p instanceof ServerWorld) {
            ChunkLoaderHandler handler = ChunkLoaderHandler.getHandler((IWorld)player.field_70170_p);
            handler.login(event);
        }
    }

    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p instanceof ServerWorld) {
            ChunkLoaderHandler handler = ChunkLoaderHandler.getHandler((IWorld)player.field_70170_p);
            handler.logout(event);
        }
    }

    private static void onWorldLoad(WorldEvent.Load event) {
        ServerWorld world;
        if (event.getWorld() instanceof ServerWorld && (world = (ServerWorld)event.getWorld()).func_234923_W_() == World.field_234918_g_) {
            ChunkLoaderHandler handler = ChunkLoaderHandler.getHandler((IWorld)world);
            handler.onOverWorldLoad();
        }
    }

    private static void onWorldTick(TickEvent.WorldTickEvent event) {
        ChunkLoaderHandler handler;
        ServerWorld world;
        if (event.world instanceof ServerWorld && (world = (ServerWorld)event.world).func_234923_W_() == World.field_234918_g_ && (handler = ChunkLoaderHandler.getHandler((IWorld)world)) != null) {
            handler.tick(event);
        }
    }

    private static void attachCapabilities(AttachCapabilitiesEvent<World> event) {
        if (((World)event.getObject()).field_72995_K) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getObject();
        if (world.func_234923_W_() != World.field_234918_g_) {
            return;
        }
        event.addCapability(KEY, (ICapabilityProvider)new SimpleCapProviderSerializable(HANDLER_CAPABILITY, (Object)new ChunkLoaderHandler(world.func_73046_m())));
    }

    protected ChunkLoaderHandler(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public void addChunkLoader(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        Organiser organiser = this.getOrganiser(loader);
        if (this.canLoadChunks(loader, loader.getChunks())) {
            organiser.addChunkLoader(loader);
        } else {
            loader.deactivate();
        }
    }

    @Override
    public void removeChunkLoader(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        Organiser organiser = this.getOrganiser(loader);
        organiser.remChunkLoader(loader);
    }

    @Override
    public boolean canLoadChunks(IChunkLoader loader, Set<ChunkPos> newChunks) {
        Objects.requireNonNull(loader);
        UUID player = Objects.requireNonNull(loader.getOwner());
        ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
        int totalLoaded = this.getLoadedChunkCount(player);
        Organiser organiser = this.getOrganiser(loader);
        Set<ChunkPos> currentLoaded = organiser.forcedChunksByLoader.get(loader);
        int netChange = newChunks.size();
        if (currentLoaded != null && !currentLoaded.isEmpty()) {
            netChange = newChunks.size() - Sets.intersection(newChunks, currentLoaded).size();
        }
        return ChickenChunksConfig.doesBypassRestrictions(this.server, player) || totalLoaded + netChange <= restrictions.getTotalAllowedChunks();
    }

    @Override
    public void updateLoader(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        Organiser organiser = this.getOrganiser(loader);
        organiser.updateLoader(loader);
    }

    public void login(PlayerEvent.PlayerLoggedInEvent event) {
        this.loginTimes.put((Object)event.getPlayer().func_110124_au(), System.currentTimeMillis());
        this.reviveList.addAll(this.playerOrganisers.row((Object)event.getPlayer().func_110124_au()).values());
    }

    public void logout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID player = event.getPlayer().func_110124_au();
        ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
        if (!restrictions.canLoadOffline()) {
            this.deviveList.addAll(this.playerOrganisers.row((Object)player).values());
        }
    }

    private void onOverWorldLoad() {
        for (Map.Entry playerEntry : this.playerOrganisers.rowMap().entrySet()) {
            long curr = System.currentTimeMillis();
            UUID player = (UUID)playerEntry.getKey();
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
            int timeout = restrictions.getOfflineTimeout();
            long lastSeen = this.loginTimes.getOrDefault((Object)player, -1L);
            if (!restrictions.canLoadOffline() && lastSeen == -1L && (curr - lastSeen) / 60000L >= (long)timeout) continue;
            this.reviveList.addAll(((Map)playerEntry.getValue()).values());
        }
    }

    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.world.func_82737_E() % 1200L == 0L) {
                long curr = System.currentTimeMillis();
                for (ServerPlayerEntity serverPlayerEntity : this.server.func_184103_al().func_181057_v()) {
                    this.loginTimes.put((Object)serverPlayerEntity.func_110124_au(), curr);
                }
                for (Map.Entry entry : this.playerOrganisers.rowMap().entrySet()) {
                    UUID player = (UUID)entry.getKey();
                    ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
                    if (restrictions.canLoadOffline()) continue;
                    int timeout = restrictions.getOfflineTimeout();
                    long lastSeen = this.loginTimes.getOrDefault((Object)player, -1L);
                    if (lastSeen == curr || timeout != 0 && lastSeen != -1L && (curr - lastSeen) / 60000L >= (long)timeout) continue;
                    this.deviveList.addAll(((Map)entry.getValue()).values());
                }
            }
            this.playerOrganisers.values().forEach(Organiser::onTickEnd);
            for (Organiser organiser : this.reviveList) {
                RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)organiser.dim);
                ServerWorld serverWorld = this.server.func_71218_a(key);
                if (serverWorld == null) continue;
                organiser.revive(serverWorld);
            }
            this.reviveList.clear();
            for (Organiser organiser : this.deviveList) {
                organiser.devive();
            }
            this.deviveList.clear();
        }
    }

    public void remChunk(IChunkLoader loader, ResourceLocation dim, ChunkPos pos) {
        ChunkTicket ticket = (ChunkTicket)this.activeTickets.get((Object)dim, (Object)pos);
        if (ticket != null) {
            if (ticket.remLoader(loader)) {
                this.activeTickets.remove((Object)dim, (Object)pos);
            }
            if (DEBUG) {
                logger.info("Loader {} Un-Forcing chunk: {}", (Object)loader.pos(), (Object)pos);
            }
        }
    }

    public void addChunk(IChunkLoader loader, ResourceLocation dim, ChunkPos pos) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dim);
        ServerWorld world = this.server.func_71218_a(key);
        ChunkTicket ticket = ChunkLoaderHandler.computeIfAbsent(this.activeTickets, dim, pos, () -> new ChunkTicket(world, pos));
        ticket.addLoader(loader);
        if (DEBUG) {
            logger.info("Loader {} Forcing chunk: {}", (Object)loader.pos(), (Object)pos);
        }
    }

    public int getLoadedChunkCount(UUID player) {
        return this.playerOrganisers.row((Object)player).values().stream().mapToInt(organiser -> organiser.forcedChunksByChunk.size()).sum();
    }

    public Organiser getOrganiser(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        UUID player = Objects.requireNonNull(loader.getOwner());
        return this.getOrganiser((RegistryKey<World>)loader.world().func_234923_W_(), player);
    }

    public Organiser getOrganiser(RegistryKey<World> dim, UUID player) {
        return this.getOrganiser(dim.func_240901_a_(), player);
    }

    public Organiser getOrganiser(ResourceLocation dim, UUID player) {
        return ChunkLoaderHandler.computeIfAbsent(this.playerOrganisers, player, dim, () -> new Organiser(this, dim, player));
    }

    private static ChunkLoaderHandler getHandler(IWorld world) {
        return (ChunkLoaderHandler)IChunkLoaderHandler.getCapability(world);
    }

    private static <R, C, V> V computeIfAbsent(Table<R, C, V> table, R r, C c, Supplier<V> vFunc) {
        Object val = table.get(r, c);
        if (val == null) {
            val = vFunc.get();
            table.put(r, c, val);
        }
        return (V)val;
    }

    private static class Storage
    implements Capability.IStorage<IChunkLoaderHandler> {
        private Storage() {
        }

        @Nullable
        public INBT writeNBT(Capability<IChunkLoaderHandler> capability, IChunkLoaderHandler instance, Direction side) {
            if (!(instance instanceof ChunkLoaderHandler)) {
                return null;
            }
            ChunkLoaderHandler handler = (ChunkLoaderHandler)instance;
            CompoundNBT tag = new CompoundNBT();
            ListNBT playerList = new ListNBT();
            for (Map.Entry playerEntry : handler.playerOrganisers.rowMap().entrySet()) {
                CompoundNBT playerTag = new CompoundNBT();
                playerTag.func_186854_a("player", (UUID)playerEntry.getKey());
                ListNBT dimensions = new ListNBT();
                for (Map.Entry dimEntry : ((Map)playerEntry.getValue()).entrySet()) {
                    if (((Organiser)dimEntry.getValue()).isEmpty()) continue;
                    CompoundNBT dimTag = new CompoundNBT();
                    dimTag.func_74778_a("dimension", ((ResourceLocation)dimEntry.getKey()).toString());
                    dimTag.func_218657_a("organiser", (INBT)((Organiser)dimEntry.getValue()).write(new CompoundNBT()));
                    dimensions.add((Object)dimTag);
                }
                if (dimensions.isEmpty()) continue;
                playerTag.func_218657_a("dimensions", (INBT)dimensions);
                playerList.add((Object)playerTag);
            }
            tag.func_218657_a("playerOrganisers", (INBT)playerList);
            ListNBT loginList = new ListNBT();
            for (Object2LongMap.Entry uuidEntry : handler.loginTimes.object2LongEntrySet()) {
                CompoundNBT playerTag = new CompoundNBT();
                playerTag.func_186854_a("player", (UUID)uuidEntry.getKey());
                playerTag.func_74772_a("time", uuidEntry.getLongValue());
                loginList.add((Object)playerTag);
            }
            tag.func_218657_a("loginTimes", (INBT)loginList);
            return tag;
        }

        public void readNBT(Capability<IChunkLoaderHandler> capability, IChunkLoaderHandler instance, Direction side, INBT nbt) {
            if (!(instance instanceof ChunkLoaderHandler)) {
                return;
            }
            ChunkLoaderHandler handler = (ChunkLoaderHandler)instance;
            CompoundNBT tag = (CompoundNBT)nbt;
            ListNBT playerList = tag.func_150295_c("playerOrganisers", 10);
            for (int i = 0; i < playerList.size(); ++i) {
                CompoundNBT playerTag = playerList.func_150305_b(i);
                UUID player = playerTag.func_186857_a("player");
                ListNBT dimensions = playerTag.func_150295_c("dimensions", 10);
                for (int j = 0; j < dimensions.size(); ++j) {
                    CompoundNBT dimTag = dimensions.func_150305_b(j);
                    ResourceLocation dim = new ResourceLocation(dimTag.func_74779_i("dimension"));
                    Organiser organiser = new Organiser(handler, dim, player).read(dimTag.func_74775_l("organiser"));
                    handler.playerOrganisers.put((Object)player, (Object)dim, (Object)organiser);
                }
            }
            ListNBT loginList = tag.func_150295_c("times", 10);
            for (int i = 0; i < loginList.size(); ++i) {
                CompoundNBT playerTag = loginList.func_150305_b(i);
                handler.loginTimes.put((Object)playerTag.func_186857_a("player"), playerTag.func_74763_f("time"));
            }
        }
    }
}

