/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiSlider
extends AbstractSlider {
    protected String prefix;
    protected String suffix;
    protected double minVal;
    protected double maxVal;
    protected boolean showDec;
    protected boolean showText;
    protected Map<Double, String> additionalText = new HashMap<Double, String>();
    protected Map<Double, String> substituteText = new HashMap<Double, String>();
    protected ISlider applyValueHandler;
    protected ISlider releaseHandler;

    protected GuiSlider(int xIn, int yIn, int widthIn, int heightIn, String prefix, String suffix, double minVal, double maxVal, double curVal, boolean showDec, boolean showText, ISlider applyValueHandler, ISlider releaseHandler) {
        super(xIn, yIn, widthIn, heightIn, (ITextComponent)new StringTextComponent(""), (curVal - minVal) / (maxVal - minVal));
        this.prefix = prefix;
        this.suffix = suffix;
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.showDec = showDec;
        this.showText = showText;
        this.applyValueHandler = applyValueHandler;
        this.releaseHandler = releaseHandler;
        this.func_230979_b_();
    }

    public GuiSlider addSubstituteText(double val, String text) {
        this.substituteText.put(val, text);
        this.func_230979_b_();
        return this;
    }

    public GuiSlider addAdditionalText(double val, String text) {
        this.additionalText.put(val, text);
        this.func_230979_b_();
        return this;
    }

    protected void func_230979_b_() {
        String message;
        double dispVal;
        if (this.showDec) {
            dispVal = (double)((int)(this.getValue() * 10.0)) / 10.0;
            message = this.prefix + dispVal + this.suffix;
        } else {
            dispVal = this.getValueInt();
            message = this.prefix + (int)dispVal + this.suffix;
        }
        if (this.showText) {
            double keyVal;
            for (Map.Entry<Double, String> entry : this.substituteText.entrySet()) {
                keyVal = entry.getKey();
                if (!this.showDec) {
                    keyVal = Math.round(keyVal);
                }
                if (dispVal != keyVal) continue;
                message = this.prefix + entry.getValue();
                break;
            }
            for (Map.Entry<Double, String> entry : this.additionalText.entrySet()) {
                keyVal = entry.getKey();
                if (!this.showDec) {
                    keyVal = Math.round(keyVal);
                }
                if (dispVal != entry.getKey()) continue;
                message = message + " (" + entry.getValue() + ")";
                break;
            }
            this.func_238482_a_((ITextComponent)new StringTextComponent(message));
        }
    }

    public void func_231000_a__(double posX, double posY) {
        super.func_231000_a__(posX, posY);
        if (this.releaseHandler != null) {
            this.releaseHandler.action(this);
        }
    }

    protected void func_230972_a_() {
        if (this.applyValueHandler != null) {
            this.applyValueHandler.action(this);
        }
    }

    public int getValueInt() {
        return (int)Math.round(this.field_230683_b_ * (this.maxVal - this.minVal) + this.minVal);
    }

    public double getValue() {
        return this.field_230683_b_ * (this.maxVal - this.minVal) + this.minVal;
    }

    public static interface ISlider {
        public void action(GuiSlider var1);
    }
}

