/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.ConfigScreen;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.gui.ClothRequiresRestartScreen;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.InputMappings;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfigScreen
extends Screen
implements ConfigScreen {
    protected static final ResourceLocation CONFIG_TEX = new ResourceLocation("cloth-config2", "textures/gui/cloth_config.png");
    private boolean legacyEdited = false;
    private final ResourceLocation backgroundLocation;
    protected boolean legacyRequiresRestart = false;
    protected boolean confirmSave;
    protected final Screen parent;
    private boolean alwaysShowTabs = false;
    private boolean transparentBackground = false;
    @Nullable
    private ITextComponent defaultFallbackCategory = null;
    public int selectedCategoryIndex = 0;
    private boolean editable = true;
    private KeyCodeEntry focusedBinding;
    private ModifierKeyCode startedKeyCode = null;
    private final List<Tooltip> tooltips = Lists.newArrayList();
    @Nullable
    private Runnable savingRunnable = null;
    @Nullable
    protected Consumer<Screen> afterInitConsumer = null;

    protected AbstractConfigScreen(Screen parent, ITextComponent title, ResourceLocation backgroundLocation) {
        super(title);
        this.parent = parent;
        this.backgroundLocation = backgroundLocation;
    }

    @Override
    public void setSavingRunnable(@Nullable Runnable savingRunnable) {
        this.savingRunnable = savingRunnable;
    }

    @Override
    public void setAfterInitConsumer(@Nullable Consumer<Screen> afterInitConsumer) {
        this.afterInitConsumer = afterInitConsumer;
    }

    @Override
    public ResourceLocation getBackgroundLocation() {
        return this.backgroundLocation;
    }

    @Override
    public boolean isRequiresRestart() {
        if (this.legacyRequiresRestart) {
            return true;
        }
        for (List<AbstractConfigEntry<?>> entries : this.getCategorizedEntries().values()) {
            for (AbstractConfigEntry<?> entry : entries) {
                if (entry.getConfigError().isPresent() || !entry.isEdited() || !entry.isRequiresRestart()) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Map<ITextComponent, List<AbstractConfigEntry<?>>> getCategorizedEntries();

    @Override
    public boolean isEdited() {
        if (this.legacyEdited) {
            return true;
        }
        for (List<AbstractConfigEntry<?>> entries : this.getCategorizedEntries().values()) {
            for (AbstractConfigEntry<?> entry : entries) {
                if (!entry.isEdited()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setEdited(boolean edited) {
        this.legacyEdited = edited;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setEdited(boolean edited, boolean legacyRequiresRestart) {
        this.setEdited(edited);
        if (!this.legacyRequiresRestart && legacyRequiresRestart) {
            this.legacyRequiresRestart = legacyRequiresRestart;
        }
    }

    public boolean isShowingTabs() {
        return this.isAlwaysShowTabs() || this.getCategorizedEntries().size() > 1;
    }

    public boolean isAlwaysShowTabs() {
        return this.alwaysShowTabs;
    }

    @ApiStatus.Internal
    public void setAlwaysShowTabs(boolean alwaysShowTabs) {
        this.alwaysShowTabs = alwaysShowTabs;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground && Minecraft.func_71410_x().field_71441_e != null;
    }

    @ApiStatus.Internal
    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
    }

    public ITextComponent getFallbackCategory() {
        if (this.defaultFallbackCategory != null) {
            return this.defaultFallbackCategory;
        }
        return this.getCategorizedEntries().keySet().iterator().next();
    }

    @ApiStatus.Internal
    public void setFallbackCategory(@Nullable ITextComponent defaultFallbackCategory) {
        this.defaultFallbackCategory = defaultFallbackCategory;
        ArrayList categories = Lists.newArrayList(this.getCategorizedEntries().keySet());
        for (int i = 0; i < categories.size(); ++i) {
            ITextComponent category = (ITextComponent)categories.get(i);
            if (!category.equals(this.getFallbackCategory())) continue;
            this.selectedCategoryIndex = i;
            break;
        }
    }

    @Override
    public void saveAll(boolean openOtherScreens) {
        for (List entries : Lists.newArrayList(this.getCategorizedEntries().values())) {
            for (AbstractConfigEntry entry : entries) {
                entry.save();
            }
        }
        this.save();
        this.setEdited(false);
        if (openOtherScreens) {
            if (this.isRequiresRestart()) {
                this.field_230706_i_.func_147108_a((Screen)new ClothRequiresRestartScreen(this.parent));
            } else {
                this.field_230706_i_.func_147108_a(this.parent);
            }
        }
        this.legacyRequiresRestart = false;
    }

    public void save() {
        Optional.ofNullable(this.savingRunnable).ifPresent(Runnable::run);
    }

    public boolean isEditable() {
        return this.editable;
    }

    @ApiStatus.Internal
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @ApiStatus.Internal
    public void setConfirmSave(boolean confirmSave) {
        this.confirmSave = confirmSave;
    }

    public KeyCodeEntry getFocusedBinding() {
        return this.focusedBinding;
    }

    @ApiStatus.Internal
    public void setFocusedBinding(KeyCodeEntry focusedBinding) {
        this.focusedBinding = focusedBinding;
        if (focusedBinding != null) {
            this.startedKeyCode = this.focusedBinding.getValue();
            this.startedKeyCode.setKeyCodeAndModifier(InputMappings.field_197958_a, Modifier.none());
        } else {
            this.startedKeyCode = null;
        }
    }

    public boolean func_231048_c_(double double_1, double double_2, int int_1) {
        if (this.focusedBinding != null && this.startedKeyCode != null && !this.startedKeyCode.isUnknown() && this.focusedBinding.isAllowMouse()) {
            this.focusedBinding.setValue(this.startedKeyCode);
            this.setFocusedBinding(null);
            return true;
        }
        return super.func_231048_c_(double_1, double_2, int_1);
    }

    public boolean func_223281_a_(int int_1, int int_2, int int_3) {
        if (this.focusedBinding != null && this.startedKeyCode != null && this.focusedBinding.isAllowKey()) {
            this.focusedBinding.setValue(this.startedKeyCode);
            this.setFocusedBinding(null);
            return true;
        }
        return super.func_223281_a_(int_1, int_2, int_3);
    }

    public boolean func_231044_a_(double double_1, double double_2, int int_1) {
        if (this.focusedBinding != null && this.startedKeyCode != null && this.focusedBinding.isAllowMouse()) {
            if (this.startedKeyCode.isUnknown()) {
                this.startedKeyCode.setKeyCode(InputMappings.Type.MOUSE.func_197944_a(int_1));
            } else if (this.focusedBinding.isAllowModifiers() && this.startedKeyCode.getType() == InputMappings.Type.KEYSYM) {
                int code = this.startedKeyCode.getKeyCode().func_197937_c();
                if (Minecraft.field_142025_a ? code == 343 || code == 347 : code == 341 || code == 345) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                    this.startedKeyCode.setKeyCode(InputMappings.Type.MOUSE.func_197944_a(int_1));
                    return true;
                }
                if (code == 344 || code == 340) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                    this.startedKeyCode.setKeyCode(InputMappings.Type.MOUSE.func_197944_a(int_1));
                    return true;
                }
                if (code == 342 || code == 346) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                    this.startedKeyCode.setKeyCode(InputMappings.Type.MOUSE.func_197944_a(int_1));
                    return true;
                }
            }
            return true;
        }
        if (this.focusedBinding != null) {
            return true;
        }
        return super.func_231044_a_(double_1, double_2, int_1);
    }

    public boolean func_231046_a_(int int_1, int int_2, int int_3) {
        if (this.focusedBinding != null && (this.focusedBinding.isAllowKey() || int_1 == 256)) {
            if (int_1 != 256) {
                if (this.startedKeyCode.isUnknown()) {
                    this.startedKeyCode.setKeyCode(InputMappings.func_197954_a((int)int_1, (int)int_2));
                } else if (this.focusedBinding.isAllowModifiers()) {
                    if (this.startedKeyCode.getType() == InputMappings.Type.KEYSYM) {
                        int code = this.startedKeyCode.getKeyCode().func_197937_c();
                        if (Minecraft.field_142025_a ? code == 343 || code == 347 : code == 341 || code == 345) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                            this.startedKeyCode.setKeyCode(InputMappings.func_197954_a((int)int_1, (int)int_2));
                            return true;
                        }
                        if (code == 344 || code == 340) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                            this.startedKeyCode.setKeyCode(InputMappings.func_197954_a((int)int_1, (int)int_2));
                            return true;
                        }
                        if (code == 342 || code == 346) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                            this.startedKeyCode.setKeyCode(InputMappings.func_197954_a((int)int_1, (int)int_2));
                            return true;
                        }
                    }
                    if (Minecraft.field_142025_a ? int_1 == 343 || int_1 == 347 : int_1 == 341 || int_1 == 345) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                        return true;
                    }
                    if (int_1 == 344 || int_1 == 340) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                        return true;
                    }
                    if (int_1 == 342 || int_1 == 346) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                        return true;
                    }
                }
            } else {
                this.focusedBinding.setValue(ModifierKeyCode.unknown());
                this.setFocusedBinding(null);
            }
            return true;
        }
        if (this.focusedBinding != null && int_1 != 256) {
            return true;
        }
        if (int_1 == 256 && this.func_231178_ax__()) {
            return this.quit();
        }
        return super.func_231046_a_(int_1, int_2, int_3);
    }

    protected final boolean quit() {
        if (this.confirmSave && this.isEdited()) {
            this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen((BooleanConsumer)new QuitSaveConsumer(), (ITextComponent)new TranslationTextComponent("text.cloth-config.quit_config"), (ITextComponent)new TranslationTextComponent("text.cloth-config.quit_config_sure"), (ITextComponent)new TranslationTextComponent("text.cloth-config.quit_discard"), (ITextComponent)new TranslationTextComponent("gui.cancel")));
        } else {
            this.field_230706_i_.func_147108_a(this.parent);
        }
        return true;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        boolean edited = this.isEdited();
        Optional.ofNullable(this.getQuitButton()).ifPresent(button -> button.func_238482_a_((ITextComponent)(edited ? new TranslationTextComponent("text.cloth-config.cancel_discard") : new TranslationTextComponent("gui.cancel"))));
        for (IGuiEventListener child : this.func_231039_at__()) {
            if (!(child instanceof ITickableTileEntity)) continue;
            ((ITickableTileEntity)child).func_73660_a();
        }
    }

    @Nullable
    protected Widget getQuitButton() {
        return null;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        for (Tooltip tooltip : this.tooltips) {
            this.func_238654_b_(matrices, tooltip.getText(), tooltip.getX(), tooltip.getY());
        }
        this.tooltips.clear();
    }

    @Override
    public void addTooltip(Tooltip tooltip) {
        this.tooltips.add(tooltip);
    }

    protected void overlayBackground(MatrixStack matrices, Rectangle rect, int red, int green, int blue, int startAlpha, int endAlpha) {
        this.overlayBackground(matrices.func_227866_c_().func_227870_a_(), rect, red, green, blue, startAlpha, endAlpha);
    }

    protected void overlayBackground(Matrix4f matrix, Rectangle rect, int red, int green, int blue, int startAlpha, int endAlpha) {
        if (this.isTransparentBackground()) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.field_230706_i_.func_110434_K().func_110577_a(this.getBackgroundLocation());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_227888_a_(matrix, (float)rect.getMinX(), (float)rect.getMaxY(), 0.0f).func_225583_a_((float)rect.getMinX() / 32.0f, (float)rect.getMaxY() / 32.0f).func_225586_a_(red, green, blue, endAlpha).func_181675_d();
        buffer.func_227888_a_(matrix, (float)rect.getMaxX(), (float)rect.getMaxY(), 0.0f).func_225583_a_((float)rect.getMaxX() / 32.0f, (float)rect.getMaxY() / 32.0f).func_225586_a_(red, green, blue, endAlpha).func_181675_d();
        buffer.func_227888_a_(matrix, (float)rect.getMaxX(), (float)rect.getMinY(), 0.0f).func_225583_a_((float)rect.getMaxX() / 32.0f, (float)rect.getMinY() / 32.0f).func_225586_a_(red, green, blue, startAlpha).func_181675_d();
        buffer.func_227888_a_(matrix, (float)rect.getMinX(), (float)rect.getMinY(), 0.0f).func_225583_a_((float)rect.getMinX() / 32.0f, (float)rect.getMinY() / 32.0f).func_225586_a_(red, green, blue, startAlpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public void func_238653_a_(MatrixStack matrices, Style style, int x, int y) {
        super.func_238653_a_(matrices, style, x, y);
    }

    public boolean func_230455_a_(@Nullable Style style) {
        if (style == null) {
            return false;
        }
        ClickEvent clickEvent = style.func_150235_h();
        if (clickEvent != null && clickEvent.func_150669_a() == ClickEvent.Action.OPEN_URL) {
            try {
                URI uri = new URI(clickEvent.func_150668_b());
                String string = uri.getScheme();
                if (string == null) {
                    throw new URISyntaxException(clickEvent.func_150668_b(), "Missing protocol");
                }
                if (!string.equalsIgnoreCase("http") && !string.equalsIgnoreCase("https")) {
                    throw new URISyntaxException(clickEvent.func_150668_b(), "Unsupported protocol: " + string.toLowerCase(Locale.ROOT));
                }
                Minecraft.func_71410_x().func_147108_a((Screen)new ConfirmOpenLinkScreen(openInBrowser -> {
                    if (openInBrowser) {
                        Util.func_110647_a().func_195642_a(uri);
                    }
                    Minecraft.func_71410_x().func_147108_a((Screen)this);
                }, clickEvent.func_150668_b(), true));
            }
            catch (URISyntaxException e) {
                ClothConfigInitializer.LOGGER.error("Can't open url for {}", (Object)clickEvent, (Object)e);
            }
            return true;
        }
        return super.func_230455_a_(style);
    }

    private class QuitSaveConsumer
    implements BooleanConsumer {
        private QuitSaveConsumer() {
        }

        public void accept(boolean t) {
            if (!t) {
                AbstractConfigScreen.this.field_230706_i_.func_147108_a((Screen)AbstractConfigScreen.this);
            } else {
                AbstractConfigScreen.this.field_230706_i_.func_147108_a(AbstractConfigScreen.this.parent);
            }
        }
    }
}

