/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fusion;

import java.util.EnumSet;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.lib.multiblock.StructureHelper;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlockTypes;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class FusionReactorValidator
extends CuboidStructureValidator<FusionReactorMultiblockData> {
    private static final VoxelCuboid BOUNDS = new VoxelCuboid(5, 5, 5);
    private static final byte[][] ALLOWED_GRID = new byte[][]{{0, 0, 1, 0, 0}, {0, 1, 2, 1, 0}, {1, 2, 2, 2, 1}, {0, 1, 2, 1, 0}, {0, 0, 1, 0, 0}};

    protected FormationProtocol.StructureRequirement getStructureRequirement(BlockPos pos) {
        VoxelCuboid.WallRelative relative = this.cuboid.getWallRelative(pos);
        if (relative.isWall()) {
            Structure.Axis axis = Structure.Axis.get((Direction)this.cuboid.getSide(pos));
            Structure.Axis h = axis.horizontal();
            Structure.Axis v = axis.vertical();
            pos = pos.func_177973_b((Vector3i)this.cuboid.getMinPos());
            return FormationProtocol.StructureRequirement.REQUIREMENTS[ALLOWED_GRID[h.getCoord(pos)][v.getCoord(pos)]];
        }
        return super.getStructureRequirement(pos);
    }

    protected FormationProtocol.FormationResult validateFrame(FormationProtocol<FusionReactorMultiblockData> ctx, BlockPos pos, BlockState state, FormationProtocol.CasingType type, boolean needsFrame) {
        boolean isControllerPos = pos.func_177956_o() == this.cuboid.getMaxPos().func_177956_o() && pos.func_177958_n() == this.cuboid.getMinPos().func_177958_n() + 2 && pos.func_177952_p() == this.cuboid.getMinPos().func_177952_p() + 2;
        boolean controller = this.structure.getTile(pos) instanceof TileEntityFusionReactorController;
        if (isControllerPos && !controller) {
            return FormationProtocol.FormationResult.fail((ILangEntry)MekanismLang.MULTIBLOCK_INVALID_NO_CONTROLLER);
        }
        if (!isControllerPos && controller) {
            return FormationProtocol.FormationResult.fail((ILangEntry)MekanismLang.MULTIBLOCK_INVALID_CONTROLLER_CONFLICT);
        }
        return super.validateFrame(ctx, pos, state, type, needsFrame);
    }

    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.func_177230_c();
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.FUSION_REACTOR_FRAME})) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.FUSION_REACTOR_PORT})) {
            return FormationProtocol.CasingType.VALVE;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.FUSION_REACTOR_CONTROLLER, GeneratorsBlockTypes.FUSION_REACTOR_LOGIC_ADAPTER, GeneratorsBlockTypes.LASER_FOCUS_MATRIX})) {
            return FormationProtocol.CasingType.OTHER;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    public boolean precheck() {
        this.cuboid = StructureHelper.fetchCuboid((Structure)this.structure, (VoxelCuboid)BOUNDS, (VoxelCuboid)BOUNDS, EnumSet.allOf(VoxelCuboid.CuboidSide.class), (int)72);
        return this.cuboid != null;
    }
}

