/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileEntityGenerator
extends TileEntityMekanism {
    public FloatingLong output;
    private BasicEnergyContainer energyContainer;

    public TileEntityGenerator(IBlockProvider blockProvider, @Nonnull FloatingLong out) {
        super(blockProvider);
        this.output = out;
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.CONFIG_CARD_CAPABILITY, (Object)((Object)this)));
    }

    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.FRONT};
    }

    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(() -> ((TileEntityGenerator)this).getDirection());
        this.energyContainer = BasicEnergyContainer.output((FloatingLong)MachineEnergyContainer.validateBlock((TileEntityMekanism)this).getStorage(), (IContentsListener)this);
        builder.addContainer((IEnergyContainer)this.energyContainer, this.getEnergySides());
        return builder.build();
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        if (MekanismUtils.canFunction((TileEntityMekanism)this)) {
            EnumSet<Direction> emitDirections = EnumSet.noneOf(Direction.class);
            Direction direction = this.getDirection();
            for (RelativeSide energySide : this.getEnergySides()) {
                emitDirections.add(energySide.getDirection(direction));
            }
            CableUtils.emit(emitDirections, (IEnergyContainer)this.energyContainer, (TileEntity)this, (FloatingLong)this.getMaxOutput());
        }
    }

    @ComputerMethod
    public FloatingLong getMaxOutput() {
        return this.output;
    }

    public BasicEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }
}

