/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityFusionReactorController
extends TileEntityFusionReactorBlock {
    public TileEntityFusionReactorController() {
        super((IBlockProvider)GeneratorsBlocks.FUSION_REACTOR_CONTROLLER);
        this.addDisabledCapabilities(new Capability[]{Capabilities.GAS_HANDLER_CAPABILITY, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Capabilities.HEAT_HANDLER_CAPABILITY});
        this.addDisabledCapabilities(EnergyCompatUtils.getEnabledEnergyCapabilities());
        this.addSemiDisabledCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, () -> !((FusionReactorMultiblockData)this.getMultiblock()).isFormed());
        this.delaySupplier = () -> 0;
    }

    protected boolean onUpdateServer(FusionReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        this.setActive(multiblock.isFormed());
        return needsPacket;
    }

    protected boolean canPlaySound() {
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
        return multiblock.isFormed() && multiblock.isBurning();
    }

    @Override
    public boolean canBeMaster() {
        return true;
    }

    public boolean handles(SubstanceType type) {
        if (type == SubstanceType.GAS || type == SubstanceType.FLUID || type == SubstanceType.HEAT) {
            return false;
        }
        return super.handles(type);
    }
}

