/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client;

import cofh.thermal.core.client.renderer.model.DynamoBakedModel;
import cofh.thermal.core.client.renderer.model.EnergyCellBakedModel;
import cofh.thermal.core.client.renderer.model.FluidCellBakedModel;
import cofh.thermal.core.client.renderer.model.ItemCellBakedModel;
import cofh.thermal.core.client.renderer.model.ReconfigurableBakedModel;
import cofh.thermal.core.client.renderer.model.UnderlayBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="thermal", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ThermalTextures {
    private static final String BLOCK_ATLAS = "minecraft:textures/atlas/blocks.png";
    public static ResourceLocation DEVICE_COLLECTOR_UNDERLAY_LOC = new ResourceLocation("thermal:block/devices/device_collector_underlay");
    private static final String CONFIG_ = "thermal:block/config/";
    public static ResourceLocation MACHINE_CONFIG_NONE_LOC = new ResourceLocation("thermal:block/config/machine_config_none");
    public static ResourceLocation MACHINE_CONFIG_INPUT_LOC = new ResourceLocation("thermal:block/config/machine_config_input");
    public static ResourceLocation MACHINE_CONFIG_OUTPUT_LOC = new ResourceLocation("thermal:block/config/machine_config_output");
    public static ResourceLocation MACHINE_CONFIG_BOTH_LOC = new ResourceLocation("thermal:block/config/machine_config_both");
    public static ResourceLocation MACHINE_CONFIG_ACCESSIBLE_LOC = new ResourceLocation("thermal:block/config/machine_config_accessible");
    public static ResourceLocation CELL_CONFIG_NONE_LOC = new ResourceLocation("thermal:block/config/cell_config_none");
    public static ResourceLocation CELL_CONFIG_INPUT_LOC = new ResourceLocation("thermal:block/config/cell_config_input");
    public static ResourceLocation CELL_CONFIG_OUTPUT_LOC = new ResourceLocation("thermal:block/config/cell_config_output");
    public static ResourceLocation CELL_CONFIG_BOTH_LOC = new ResourceLocation("thermal:block/config/cell_config_both");
    public static TextureAtlasSprite MACHINE_CONFIG_NONE;
    public static TextureAtlasSprite MACHINE_CONFIG_INPUT;
    public static TextureAtlasSprite MACHINE_CONFIG_OUTPUT;
    public static TextureAtlasSprite MACHINE_CONFIG_BOTH;
    public static TextureAtlasSprite MACHINE_CONFIG_ACCESSIBLE;
    public static TextureAtlasSprite CELL_CONFIG_NONE;
    public static TextureAtlasSprite CELL_CONFIG_INPUT;
    public static TextureAtlasSprite CELL_CONFIG_OUTPUT;
    public static TextureAtlasSprite CELL_CONFIG_BOTH;
    public static TextureAtlasSprite[] ENERGY_CELL_LEVELS;
    public static TextureAtlasSprite ENERGY_CELL_LEVEL_8_C;
    public static TextureAtlasSprite[] FLUID_CELL_LEVELS;
    public static TextureAtlasSprite FLUID_CELL_LEVEL_0_C;
    public static TextureAtlasSprite FLUID_CELL_LEVEL_8_C;
    public static TextureAtlasSprite[] ITEM_CELL_LEVELS;
    public static TextureAtlasSprite ITEM_CELL_LEVEL_8_C;

    private ThermalTextures() {
    }

    @SubscribeEvent
    public static void preStitch(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().toString().equals(BLOCK_ATLAS)) {
            return;
        }
        event.addSprite(DEVICE_COLLECTOR_UNDERLAY_LOC);
        event.addSprite(MACHINE_CONFIG_NONE_LOC);
        event.addSprite(MACHINE_CONFIG_INPUT_LOC);
        event.addSprite(MACHINE_CONFIG_OUTPUT_LOC);
        event.addSprite(MACHINE_CONFIG_BOTH_LOC);
        event.addSprite(MACHINE_CONFIG_ACCESSIBLE_LOC);
        event.addSprite(CELL_CONFIG_NONE_LOC);
        event.addSprite(CELL_CONFIG_INPUT_LOC);
        event.addSprite(CELL_CONFIG_OUTPUT_LOC);
        event.addSprite(CELL_CONFIG_BOTH_LOC);
        for (int i = 0; i < 9; ++i) {
            event.addSprite(new ResourceLocation("thermal:block/cells/energy_cell_level_" + i));
            event.addSprite(new ResourceLocation("thermal:block/cells/fluid_cell_level_" + i));
            event.addSprite(new ResourceLocation("thermal:block/cells/item_cell_level_" + i));
        }
        event.addSprite(new ResourceLocation("thermal:block/cells/energy_cell_level_8c"));
        event.addSprite(new ResourceLocation("thermal:block/cells/fluid_cell_level_0c"));
        event.addSprite(new ResourceLocation("thermal:block/cells/fluid_cell_level_8c"));
        event.addSprite(new ResourceLocation("thermal:block/cells/item_cell_level_8c"));
    }

    @SubscribeEvent
    public static void postStitch(TextureStitchEvent.Post event) {
        if (!event.getMap().func_229223_g_().toString().equals(BLOCK_ATLAS)) {
            return;
        }
        UnderlayBakedModel.clearCache();
        DynamoBakedModel.clearCache();
        ReconfigurableBakedModel.clearCache();
        EnergyCellBakedModel.clearCache();
        FluidCellBakedModel.clearCache();
        ItemCellBakedModel.clearCache();
        AtlasTexture map = event.getMap();
        MACHINE_CONFIG_NONE = map.func_195424_a(MACHINE_CONFIG_NONE_LOC);
        MACHINE_CONFIG_INPUT = map.func_195424_a(MACHINE_CONFIG_INPUT_LOC);
        MACHINE_CONFIG_OUTPUT = map.func_195424_a(MACHINE_CONFIG_OUTPUT_LOC);
        MACHINE_CONFIG_BOTH = map.func_195424_a(MACHINE_CONFIG_BOTH_LOC);
        MACHINE_CONFIG_ACCESSIBLE = map.func_195424_a(MACHINE_CONFIG_ACCESSIBLE_LOC);
        CELL_CONFIG_NONE = map.func_195424_a(CELL_CONFIG_NONE_LOC);
        CELL_CONFIG_INPUT = map.func_195424_a(CELL_CONFIG_INPUT_LOC);
        CELL_CONFIG_OUTPUT = map.func_195424_a(CELL_CONFIG_OUTPUT_LOC);
        CELL_CONFIG_BOTH = map.func_195424_a(CELL_CONFIG_BOTH_LOC);
        ENERGY_CELL_LEVELS = new TextureAtlasSprite[9];
        FLUID_CELL_LEVELS = new TextureAtlasSprite[9];
        ITEM_CELL_LEVELS = new TextureAtlasSprite[9];
        for (int i = 0; i < 9; ++i) {
            ThermalTextures.ENERGY_CELL_LEVELS[i] = map.func_195424_a(new ResourceLocation("thermal:block/cells/energy_cell_level_" + i));
            ThermalTextures.FLUID_CELL_LEVELS[i] = map.func_195424_a(new ResourceLocation("thermal:block/cells/fluid_cell_level_" + i));
            ThermalTextures.ITEM_CELL_LEVELS[i] = map.func_195424_a(new ResourceLocation("thermal:block/cells/item_cell_level_" + i));
        }
        ENERGY_CELL_LEVEL_8_C = map.func_195424_a(new ResourceLocation("thermal:block/cells/energy_cell_level_8c"));
        FLUID_CELL_LEVEL_0_C = map.func_195424_a(new ResourceLocation("thermal:block/cells/fluid_cell_level_0c"));
        FLUID_CELL_LEVEL_8_C = map.func_195424_a(new ResourceLocation("thermal:block/cells/fluid_cell_level_8c"));
        ITEM_CELL_LEVEL_8_C = map.func_195424_a(new ResourceLocation("thermal:block/cells/item_cell_level_8c"));
    }
}

