/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlizzModel<T extends LivingEntity>
extends SegmentedModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer[] topCubes;
    private final ModelRenderer[] botCubes;
    private final ImmutableList<ModelRenderer> partsList;

    public BlizzModel() {
        int i;
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78784_a(0, 0).func_228303_a_(-4.5f, -4.0f, -4.0f, 9.0f, 8.0f, 8.0f, 0.0f, false);
        this.head.func_78784_a(0, 16).func_228303_a_(-4.5f, -4.0f, -6.0f, 9.0f, 4.0f, 2.0f, 0.0f, false);
        this.topCubes = new ModelRenderer[4];
        for (i = 0; i < this.topCubes.length; ++i) {
            this.topCubes[i] = new ModelRenderer((Model)this);
            this.topCubes[i].func_78793_a(0.0f, 0.0f, 0.0f);
            this.topCubes[i].func_78784_a(34, 8).func_228303_a_(-2.0f, 8.0f, -2.0f, 4.0f, 4.0f, 4.0f, 0.0f, true);
        }
        this.botCubes = new ModelRenderer[this.topCubes.length];
        for (i = 0; i < this.botCubes.length; ++i) {
            this.botCubes[i] = new ModelRenderer((Model)this);
            this.botCubes[i].func_78793_a(0.0f, 0.0f, 0.0f);
            this.botCubes[i].func_78784_a(34, 2).func_228303_a_(-2.0f, 17.0f, -2.0f, 3.0f, 3.0f, 3.0f, 0.0f, true);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.head);
        builder.addAll(Arrays.asList(this.topCubes));
        builder.addAll(Arrays.asList(this.botCubes));
        this.partsList = builder.build();
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return this.partsList;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float x = BlizzModel.bevel(ageInTicks * 0.05f);
        float z = BlizzModel.bevel(ageInTicks * 0.05f + 1.0f);
        for (int i = 0; i < this.topCubes.length; ++i) {
            this.topCubes[i].field_78800_c = x * -4.0f;
            this.topCubes[i].field_78798_e = z * 4.0f;
            this.topCubes[i].field_78797_d = MathHelper.func_76126_a((float)(ageInTicks * 0.2f + (float)(i * 4)));
            this.botCubes[i].field_78800_c = x * 3.5f;
            this.botCubes[i].field_78798_e = z * 3.5f;
            this.botCubes[i].field_78797_d = MathHelper.func_76126_a((float)(ageInTicks * 0.2f + (float)(i * 4) + 2.0f));
            float temp = -x;
            x = z;
            z = temp;
        }
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
    }

    public static float bevel(float f) {
        int floor = MathHelper.func_76141_d((float)f);
        if (f - (float)floor < 0.66667f && (floor & 1) == 0) {
            return -MathHelper.func_76134_b((float)(4.712389f * f));
        }
        return (floor >> 1 & 1) == 0 ? 1.0f : -1.0f;
    }
}

