/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.machine;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.CentrifugeRecipe;
import cofh.thermal.lib.compat.crt.actions.ActionRemoveThermalRecipeByOutput;
import cofh.thermal.lib.compat.crt.base.CRTRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.util.RecipePrintingUtil;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStack;
import com.blamejared.crafttweaker.impl.item.MCWeightedItemStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.Centrifuge")
@IRecipeHandler.For(value=CentrifugeRecipe.class)
public class CRTCentrifugeManager
implements IRecipeManager,
IRecipeHandler<CentrifugeRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, MCWeightedItemStack[] outputs, IFluidStack outputFluid, IIngredientWithAmount ingredient, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CRTRecipe crtRecipe = new CRTRecipe(resourceLocation).energy(energy).input(ingredient).output(outputs).output(outputFluid);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)crtRecipe.recipe(CentrifugeRecipe::new)));
    }

    public IRecipeType<CentrifugeRecipe> getRecipeType() {
        return TCoreRecipeTypes.RECIPE_CENTRIFUGE;
    }

    public void removeRecipe(IItemStack output) {
        this.removeRecipe(new IItemStack[]{output}, new IFluidStack[0]);
    }

    @ZenCodeType.Method
    public void removeRecipe(IItemStack[] itemOutputs, IFluidStack[] fluidOutputs) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveThermalRecipeByOutput(this, (IIngredient[])itemOutputs, fluidOutputs));
    }

    public String dumpToCommandString(IRecipeManager manager, CentrifugeRecipe recipe) {
        return String.format("<recipetype:%s>.addRecipe(\"%s\", [%s], %s, %s, %s);", recipe.func_222127_g(), recipe.func_199560_c(), RecipePrintingUtil.stringifyWeightedStacks(recipe.getOutputItems(), recipe.getOutputItemChances(), (String)", "), recipe.getOutputFluids().isEmpty() ? MCFluidStack.EMPTY.get() : RecipePrintingUtil.stringifyFluidStacks(recipe.getOutputFluids(), (String)" | "), RecipePrintingUtil.stringifyIngredients(recipe.getInputItems(), (String)" | "), recipe.getEnergy());
    }

    public Optional<Function<ResourceLocation, CentrifugeRecipe>> replaceIngredients(IRecipeManager manager, CentrifugeRecipe recipe, List<IReplacementRule> rules) throws IRecipeHandler.ReplacementNotSupportedException {
        return ReplacementHandlerHelper.replaceIngredientList(recipe.getInputItems(), Ingredient.class, (IRecipe)recipe, rules, newIngredients -> id -> new CRTRecipe((ResourceLocation)id).energy(recipe.getEnergy()).setInputItems((List<Ingredient>)newIngredients).setOutputFluids(recipe.getOutputFluids()).setOutputItems(recipe.getOutputItems(), recipe.getOutputItemChances()).recipe(CentrifugeRecipe::new));
    }
}

