/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.lib.entity.AbstractGrenadeEntity;
import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.init.TCoreReferences;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EarthGrenadeEntity
extends AbstractGrenadeEntity {
    public static int effectAmplifier = 1;
    public static int effectDuration = 200;

    public EarthGrenadeEntity(EntityType<? extends ProjectileItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public EarthGrenadeEntity(World worldIn, double x, double y, double z) {
        super(TCoreReferences.EARTH_GRENADE_ENTITY, x, y, z, worldIn);
    }

    public EarthGrenadeEntity(World worldIn, LivingEntity livingEntityIn) {
        super(TCoreReferences.EARTH_GRENADE_ENTITY, livingEntityIn, worldIn);
    }

    protected Item func_213885_i() {
        return TCoreReferences.EARTH_GRENADE_ITEM;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (Utils.isServerWorld((World)this.field_70170_p)) {
            EarthGrenadeEntity.sunderNearbyEntities((Entity)this, this.field_70170_p, this.func_233580_cy_(), this.radius);
            EarthGrenadeEntity.breakBlocks((Entity)this, this.field_70170_p, this.func_233580_cy_(), this.radius - 1, this.func_234616_v_());
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY && this.field_70173_aa < 10) {
            return;
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0, 0.0, 0.0);
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.5f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
    }

    public static void breakBlocks(Entity entity, World worldIn, BlockPos pos, int radius, @Nullable Entity entityIn) {
        if (radius <= 0) {
            return;
        }
        float f = Math.min(32, radius);
        float f2 = f * f;
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-f), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)f, (double)f))) {
            BlockState state;
            Material material;
            double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2) || (material = (state = worldIn.func_180495_p(iterPos)).func_185904_a()) != Material.field_151576_e && material != Material.field_151578_c && !(state.func_177230_c() instanceof SnowyDirtBlock)) continue;
            Utils.destroyBlock((World)worldIn, (BlockPos)iterPos, (boolean)true, (Entity)entityIn);
        }
    }

    public static void sunderNearbyEntities(Entity entity, World worldIn, BlockPos pos, int radius) {
        AxisAlignedBB area = new AxisAlignedBB(pos.func_177982_a(-radius, -radius, -radius), pos.func_177982_a(1 + radius, 1 + radius, 1 + radius));
        worldIn.func_175647_a(LivingEntity.class, area, EntityPredicates.field_94557_a).forEach(livingEntity -> livingEntity.func_195064_c(new EffectInstance(CoreReferences.SUNDERED, effectDuration, effectAmplifier, false, false)));
    }
}

