/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.dynamo;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.dynamo.GourmandFuel;
import cofh.thermal.lib.util.managers.SingleItemFuelManager;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import cofh.thermal.lib.util.recipes.internal.IDynamoFuel;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class GourmandFuelManager
extends SingleItemFuelManager {
    private static final GourmandFuelManager INSTANCE = new GourmandFuelManager();
    protected static final int DEFAULT_ENERGY = 1600;
    protected List<GourmandFuel> convertedFuels = new ArrayList<GourmandFuel>();

    public static GourmandFuelManager instance() {
        return INSTANCE;
    }

    private GourmandFuelManager() {
        super(1600);
    }

    @Override
    public boolean validFuel(ItemStack input) {
        if (input.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return false;
        }
        return this.getEnergy(input) > 0;
    }

    @Override
    protected void clear() {
        this.fuelMap.clear();
        this.convertedFuels.clear();
    }

    public int getEnergy(ItemStack stack) {
        IDynamoFuel fuel = this.getFuel(stack);
        return fuel != null ? fuel.getEnergy() : this.getEnergyFromFood(stack);
    }

    public int getEnergyFromFood(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return 0;
        }
        Food food = stack.func_77973_b().func_219967_s();
        if (food == null) {
            return 0;
        }
        int energy = food.func_221466_a() * 1600;
        if (food.func_221464_f().size() > 0) {
            for (Pair effect : food.func_221464_f()) {
                if (((EffectInstance)effect.getFirst()).func_188419_a().func_220303_e() != EffectType.HARMFUL) continue;
                return 0;
            }
            energy *= 2;
        }
        if (food.func_221469_b() > 1.0f) {
            energy *= 4;
        }
        if (food.func_221465_e()) {
            energy *= 2;
        }
        return energy >= 1000 ? energy : 0;
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.func_215366_a(TCoreRecipeTypes.FUEL_GOURMAND);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addFuel((ThermalFuel)((Object)entry.getValue()));
        }
        this.createConvertedRecipes(recipeManager);
    }

    public List<GourmandFuel> getConvertedFuels() {
        return this.convertedFuels;
    }

    protected void createConvertedRecipes(RecipeManager recipeManager) {
        for (Item item : ForgeRegistries.ITEMS) {
            ItemStack query = new ItemStack((IItemProvider)item);
            try {
                if (this.getFuel(query) != null || !this.validFuel(query)) continue;
                this.convertedFuels.add(this.convert(query, this.getEnergy(query)));
            }
            catch (Exception e) {
                ThermalCore.LOG.error(query.func_77973_b().getRegistryName() + " threw an exception when querying the fuel value as the mod author is doing non-standard things in their item code (possibly tag related). It may not display in JEI but should function as fuel.");
            }
        }
    }

    protected GourmandFuel convert(ItemStack item, int energy) {
        return new GourmandFuel(new ResourceLocation("thermal", "gourmand_" + item.func_77973_b().getRegistryName().func_110623_a()), energy, Collections.singletonList(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{item})), Collections.emptyList());
    }
}

