/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.device;

import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.core.util.recipes.device.TreeExtractorMapping;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TreeExtractorMappingSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<TreeExtractorMapping> {
    public TreeExtractorMapping fromJson(ResourceLocation recipeId, JsonObject json) {
        Block trunk = Blocks.field_150350_a;
        Block leaves = Blocks.field_150350_a;
        FluidStack fluid = FluidStack.EMPTY;
        if (json.has("trunk")) {
            trunk = RecipeJsonUtils.parseBlock((JsonElement)json.get("trunk"));
        }
        if (json.has("leaf")) {
            leaves = RecipeJsonUtils.parseBlock((JsonElement)json.get("leaf"));
        } else if (json.has("leaves")) {
            leaves = RecipeJsonUtils.parseBlock((JsonElement)json.get("leaves"));
        }
        if (json.has("result")) {
            fluid = RecipeJsonUtils.parseFluidStack((JsonElement)json.get("result"));
        } else if (json.has("fluid")) {
            fluid = RecipeJsonUtils.parseFluidStack((JsonElement)json.get("fluid"));
        }
        return new TreeExtractorMapping(recipeId, trunk, leaves, fluid);
    }

    @Nullable
    public TreeExtractorMapping fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        Block trunk = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
        Block leaves = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
        FluidStack fluid = buffer.readFluidStack();
        return new TreeExtractorMapping(recipeId, trunk, leaves, fluid);
    }

    public void toNetwork(PacketBuffer buffer, TreeExtractorMapping recipe) {
        buffer.func_192572_a(recipe.trunk.getRegistryName());
        buffer.func_192572_a(recipe.leaves.getRegistryName());
        buffer.writeFluidStack(recipe.fluid);
    }
}

