/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.compat.jei;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ThermalFuelCategory<T extends ThermalFuel>
implements IRecipeCategory<T> {
    protected final int DURATION_X = 70;
    protected final int DURATION_Y = 24;
    protected final int ENERGY_X = 106;
    protected final int ENERGY_Y = 10;
    protected final ResourceLocation uid;
    protected IDrawable background;
    protected IDrawable icon;
    protected ITextComponent name;
    protected IDrawableStatic energyBackground;
    protected IDrawableStatic durationBackground;
    protected IDrawableAnimated energy;
    protected IDrawableAnimated duration;

    public ThermalFuelCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        this(guiHelper, icon, uid, true);
    }

    public ThermalFuelCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid, boolean drawEnergy) {
        this.uid = uid;
        this.icon = guiHelper.createDrawableIngredient((Object)icon);
        if (drawEnergy) {
            this.energyBackground = Drawables.getDrawables(guiHelper).getEnergyEmpty();
            this.energy = guiHelper.createAnimatedDrawable(Drawables.getDrawables(guiHelper).getEnergyFill(), 400, IDrawableAnimated.StartDirection.BOTTOM, false);
        }
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public String getTitle() {
        return this.name.getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        if (this.energyBackground != null) {
            this.energyBackground.draw(matrixStack, 106, 10);
        }
        if (this.energy != null) {
            this.energy.draw(matrixStack, 106, 10);
        }
        if (this.durationBackground != null) {
            this.durationBackground.draw(matrixStack, 70, 24);
        }
        if (this.duration != null) {
            this.duration.draw(matrixStack, 70, 24);
        }
    }

    public List<ITextComponent> getTooltipStrings(T recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (this.energy != null && mouseX > 106.0 && mouseX < (double)(106 + this.energy.getWidth() - 1) && mouseY > 10.0 && mouseY < (double)(10 + this.energy.getHeight() - 1)) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.energy").func_240702_b_(": " + StringHelper.format((long)((ThermalFuel)((Object)recipe)).getEnergy()) + " RF"));
        }
        return tooltip;
    }
}

