/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager;

import com.legacy.conjurer_illager.IllagerRegistry;
import com.legacy.conjurer_illager.registry.IllagerStructures;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class IllagerEvents {
    @SubscribeEvent
    public void onPotionEffectGiven(PotionEvent.PotionApplicableEvent event) {
        if (event.getPotionEffect().func_188419_a().getEffect() == Effects.field_220309_E && event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == IllagerRegistry.CONJURER_HAT) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getAmount() > 0.0f && event.getSource().func_76364_f() instanceof RabbitEntity) {
            event.getSource().func_76364_f().func_184185_a(SoundEvents.field_187818_ek, 1.0f, (event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() - event.getEntityLiving().field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @SubscribeEvent
    public void onVillagerTradesAssigned(VillagerTradesEvent event) {
        try {
            if (event.getType() == VillagerProfession.field_221154_d) {
                ((List)event.getTrades().get(2)).add(new EmeraldForMapTrade(11, IllagerStructures.THEATER.getStructure(), MapDecoration.Type.RED_X, 15, 5));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class EmeraldForMapTrade
    implements VillagerTrades.ITrade {
        private final int count;
        private final Structure<?> structureName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public EmeraldForMapTrade(int emeraldCountIn, Structure<?> structureNameIn, MapDecoration.Type mapTypeIn, int maxUsesIn, int experienceValueIn) {
            this.count = emeraldCountIn;
            this.structureName = structureNameIn;
            this.mapDecorationType = mapTypeIn;
            this.maxUses = maxUsesIn;
            this.xpValue = experienceValueIn;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            if (!(trader.field_70170_p instanceof ServerWorld)) {
                return null;
            }
            ServerWorld serverworld = (ServerWorld)trader.field_70170_p;
            BlockPos blockpos = serverworld.func_241117_a_(this.structureName, trader.func_233580_cy_(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = FilledMapItem.func_195952_a((World)serverworld, (int)blockpos.func_177958_n(), (int)blockpos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_226642_a_((ServerWorld)serverworld, (ItemStack)itemstack);
                MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
                itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("filled_map." + this.structureName.func_143025_a().toLowerCase(Locale.ROOT)));
                return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.count), new ItemStack((IItemProvider)Items.field_151111_aL), itemstack, this.maxUses, this.xpValue, 0.2f);
            }
            return null;
        }
    }
}

