/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mythicbotany.MythicBotany;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.BiomeDictionary;

public class AlfheimBiomeManager {
    public static final BiomeDictionary.Type ALFHEIM = BiomeDictionary.Type.getType((String)((Object)((Object)MythicBotany.getInstance()) + "_alfheim"), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    private static final List<RegistryKey<Biome>> COMMON = new ArrayList<RegistryKey<Biome>>();
    private static final List<RegistryKey<Biome>> UNCOMMON = new ArrayList<RegistryKey<Biome>>();
    private static final List<RegistryKey<Biome>> RARE = new ArrayList<RegistryKey<Biome>>();
    private static final Map<Structure<?>, StructureSeparationSettings> STRUCTURES = new HashMap();

    public static void addCommonBiome(ResourceLocation biome) {
        AlfheimBiomeManager.addCommonBiome((RegistryKey<Biome>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome));
    }

    public static void addCommonBiome(RegistryKey<Biome> biome) {
        COMMON.add(biome);
        BiomeDictionary.addTypes(biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{ALFHEIM});
        Collections.sort(COMMON);
    }

    public static void addUncommonBiome(ResourceLocation biome) {
        AlfheimBiomeManager.addUncommonBiome((RegistryKey<Biome>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome));
    }

    public static void addUncommonBiome(RegistryKey<Biome> biome) {
        UNCOMMON.add(biome);
        BiomeDictionary.addTypes(biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{ALFHEIM});
        Collections.sort(UNCOMMON);
    }

    public static void addRareBiome(ResourceLocation biome) {
        AlfheimBiomeManager.addRareBiome((RegistryKey<Biome>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome));
    }

    public static void addRareBiome(RegistryKey<Biome> biome) {
        RARE.add(biome);
        BiomeDictionary.addTypes(biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{ALFHEIM});
        Collections.sort(RARE);
    }

    public static void addStructure(Structure<?> structure, StructureSeparationSettings settings) {
        STRUCTURES.put(structure, settings);
    }

    public static void checkBiomes(Registry<Biome> biomeRegistry) {
        COMMON.stream().filter(key -> !biomeRegistry.func_241873_b(key.func_240901_a_()).isPresent()).findFirst().ifPresent(key -> {
            throw new IllegalStateException("Alfheim Biome not registered: " + key.func_240901_a_() + "");
        });
        UNCOMMON.stream().filter(key -> !biomeRegistry.func_241873_b(key.func_240901_a_()).isPresent()).findFirst().ifPresent(key -> {
            throw new IllegalStateException("Alfheim Biome not registered: " + key.func_240901_a_() + "");
        });
        RARE.stream().filter(key -> !biomeRegistry.func_241873_b(key.func_240901_a_()).isPresent()).findFirst().ifPresent(key -> {
            throw new IllegalStateException("Alfheim Biome not registered: " + key.func_240901_a_() + "");
        });
    }

    public static RegistryKey<Biome> generate(INoiseRandom noiseRandom, int x, int y) {
        if (!RARE.isEmpty() && noiseRandom.func_202696_a(20) == 10) {
            return RARE.get(noiseRandom.func_202696_a(RARE.size()));
        }
        if (!UNCOMMON.isEmpty() && noiseRandom.func_202696_a(3) == 1) {
            return UNCOMMON.get(noiseRandom.func_202696_a(UNCOMMON.size()));
        }
        return COMMON.get(noiseRandom.func_202696_a(COMMON.size()));
    }

    public static Map<Structure<?>, StructureSeparationSettings> structureMap() {
        return Collections.unmodifiableMap(STRUCTURES);
    }
}

